/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class MethodArgumentCouldBeFinalRule
extends AbstractJavaRulechainRule {
    public MethodArgumentCouldBeFinalRule() {
        super(ASTMethodOrConstructorDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.getBody() == null) {
            return data;
        }
        this.lookForViolation(meth, data);
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructor, Object data) {
        this.lookForViolation(constructor, data);
        return data;
    }

    private void lookForViolation(ASTMethodOrConstructorDeclaration node, Object data) {
        MethodArgumentCouldBeFinalRule.checkForFinal((RuleContext)data, this, (NodeStream<ASTVariableDeclaratorId>)node.getFormalParameters().toStream().map(ASTFormalParameter::getVarId));
    }

    static void checkForFinal(RuleContext ruleContext, AbstractRule rule, NodeStream<ASTVariableDeclaratorId> variables) {
        block0: for (ASTVariableDeclaratorId var : variables) {
            if (var.isFinal()) continue;
            boolean used = false;
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : var.getLocalUsages()) {
                used = true;
                if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                continue block0;
            }
            if (!used) continue;
            rule.addViolation((Object)ruleContext, (Node)var, var.getName());
        }
    }
}

