/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class IdenticalCatchBranchesRule
extends AbstractJavaRulechainRule {
    public IdenticalCatchBranchesRule() {
        super(ASTTryStatement.class, new Class[0]);
    }

    private boolean areEquivalent(ASTCatchClause st1, ASTCatchClause st2) {
        String e1Name = st1.getParameter().getName();
        String e2Name = st2.getParameter().getName();
        return JavaAstUtils.tokenEquals(st1.getBody(), st2.getBody(), name -> name.equals(e1Name) ? e2Name : name);
    }

    private Set<List<ASTCatchClause>> equivalenceClasses(List<ASTCatchClause> catches) {
        HashSet<List<ASTCatchClause>> result = new HashSet<List<ASTCatchClause>>(catches.size());
        for (ASTCatchClause stmt : catches) {
            if (result.isEmpty()) {
                result.add(this.newEquivClass(stmt));
                continue;
            }
            boolean isNewClass = true;
            for (List list : result) {
                if (!this.areEquivalent(stmt, (ASTCatchClause)list.get(0))) continue;
                list.add(stmt);
                isNewClass = false;
                break;
            }
            if (!isNewClass) continue;
            result.add(this.newEquivClass(stmt));
        }
        return result;
    }

    private List<ASTCatchClause> newEquivClass(ASTCatchClause stmt) {
        ArrayList<ASTCatchClause> result = new ArrayList<ASTCatchClause>(2);
        result.add(stmt);
        return result;
    }

    private String getCaughtExceptionsAsString(ASTCatchClause stmt) {
        return PrettyPrintingUtil.prettyPrintType(stmt.getParameter().getTypeNode());
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        List catchStatements = node.getCatchClauses().toList();
        Set<List<ASTCatchClause>> equivClasses = this.equivalenceClasses(catchStatements);
        for (List<ASTCatchClause> identicalStmts : equivClasses) {
            if (identicalStmts.size() <= 1) continue;
            String identicalBranchName = this.getCaughtExceptionsAsString(identicalStmts.get(0));
            for (int i = 1; i < identicalStmts.size(); ++i) {
                this.addViolation(data, (Node)identicalStmts.get(i), new String[]{identicalBranchName});
            }
        }
        return data;
    }
}

