/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.StringUtil;

abstract class AbstractNamingConventionRule<T extends JavaNode>
extends AbstractJavaRulechainRule {
    static final String CAMEL_CASE = "[a-z][a-zA-Z0-9]*";
    static final String PASCAL_CASE = "[A-Z][a-zA-Z0-9]*";

    @SafeVarargs
    protected AbstractNamingConventionRule(Class<? extends JavaNode> first, Class<? extends JavaNode> ... visits) {
        super(first, visits);
    }

    PropertyBuilder.RegexPropertyBuilder defaultProp(String displayName) {
        return this.defaultProp(StringUtil.CaseConvention.SPACE_SEPARATED.convertTo(StringUtil.CaseConvention.CAMEL_CASE, displayName), displayName);
    }

    PropertyBuilder.RegexPropertyBuilder defaultProp(String name, String displayName) {
        return ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)(name + "Pattern")).desc("Regex which applies to " + displayName.trim() + " names")).defaultValue(this.defaultConvention());
    }

    abstract String defaultConvention();

    abstract String kindDisplayName(T var1, PropertyDescriptor<Pattern> var2);

    abstract String nameExtractor(T var1);

    void checkMatches(T node, PropertyDescriptor<Pattern> regex, Object data) {
        String name = this.nameExtractor(node);
        if (!((Pattern)this.getProperty(regex)).matcher(name).matches()) {
            this.addViolation(data, (Node)node, new Object[]{this.kindDisplayName(node, regex), name, ((Pattern)this.getProperty(regex)).toString()});
        }
    }
}

