/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnusedAssignmentRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> CHECK_PREFIX_INCREMENT = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkUnusedPrefixIncrement").desc("Report expressions like ++i that may be replaced with (i + 1)")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> REPORT_UNUSED_VARS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportUnusedVariables").desc("Report variables that are only initialized, and never read at all. The rule UnusedVariable already cares for that, but you can enable it if needed")).defaultValue((Object)false)).build();

    public UnusedAssignmentRule() {
        super(ASTCompilationUnit.class, new Class[0]);
        this.definePropertyDescriptor(CHECK_PREFIX_INCREMENT);
        this.definePropertyDescriptor(REPORT_UNUSED_VARS);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        DataflowPass.DataflowResult result = DataflowPass.getDataflowResult(node);
        this.reportFinished(result, (RuleContext)data);
        return data;
    }

    private void reportFinished(DataflowPass.DataflowResult result, RuleContext ruleCtx) {
        for (DataflowPass.AssignmentEntry entry : result.getUnusedAssignments()) {
            String reason;
            if (entry.isUnaryReassign() && this.isIgnorablePrefixIncrement(entry.getLocation())) continue;
            Set<DataflowPass.AssignmentEntry> killers = result.getKillers(entry);
            if (killers.isEmpty()) {
                if (entry.isField() || this.suppressUnusedVariableRuleOverlap(entry)) continue;
                reason = null;
            } else if (killers.size() == 1) {
                DataflowPass.AssignmentEntry k = killers.iterator().next();
                if (k.getLocation().equals(entry.getLocation())) {
                    if (this.suppressUnusedVariableRuleOverlap(entry)) continue;
                    reason = entry.isForeachVar() ? null : "reassigned every iteration";
                } else {
                    reason = "overwritten on line " + k.getLine();
                }
            } else {
                reason = UnusedAssignmentRule.joinLines("overwritten on lines ", killers);
            }
            if (reason == null && JavaRuleUtil.isExplicitUnusedVarName(entry.getVarId().getName())) continue;
            this.addViolationWithMessage(ruleCtx, (Node)entry.getLocation(), UnusedAssignmentRule.makeMessage(entry, reason, entry.isField()));
        }
    }

    private boolean suppressUnusedVariableRuleOverlap(DataflowPass.AssignmentEntry entry) {
        return (Boolean)this.getProperty(REPORT_UNUSED_VARS) == false && (entry.isInitializer() || entry.isBlankDeclaration());
    }

    private static String getKind(ASTVariableDeclaratorId id) {
        if (id.isField()) {
            return "field";
        }
        if (id.isResourceDeclaration()) {
            return "resource";
        }
        if (id.isExceptionBlockParameter()) {
            return "exception parameter";
        }
        if (id.getNthParent(3) instanceof ASTForeachStatement) {
            return "loop variable";
        }
        if (id.isFormalParameter()) {
            return "parameter";
        }
        return "variable";
    }

    private boolean isIgnorablePrefixIncrement(JavaNode assignment) {
        if (assignment instanceof ASTUnaryExpression) {
            UnaryOp op = ((ASTUnaryExpression)assignment).getOperator();
            return (Boolean)this.getProperty(CHECK_PREFIX_INCREMENT) == false && !op.isPure() && op.isPrefix() && !(assignment.getParent() instanceof ASTExpressionStatement);
        }
        return false;
    }

    private static String makeMessage(DataflowPass.AssignmentEntry assignment, @Nullable String reason, boolean isField) {
        StringBuilder result = new StringBuilder(64);
        if (assignment.isInitializer()) {
            result.append(isField ? "the field initializer for" : "the initializer for variable");
        } else if (assignment.isBlankDeclaration()) {
            if (reason != null) {
                result.append("the initial value of ");
            }
            result.append(UnusedAssignmentRule.getKind(assignment.getVarId()));
        } else {
            if (assignment.isUnaryReassign()) {
                result.append("the updated value of ");
            } else {
                result.append("the value assigned to ");
            }
            result.append(isField ? "field" : "variable");
        }
        result.append(" ''").append(assignment.getVarId().getName()).append("''");
        result.append(" is never used");
        if (reason != null) {
            result.append(" (").append(reason).append(")");
        }
        result.setCharAt(0, Character.toUpperCase(result.charAt(0)));
        return result.toString();
    }

    private static String joinLines(String prefix, Set<DataflowPass.AssignmentEntry> killers) {
        StringBuilder sb = new StringBuilder(prefix);
        ArrayList<DataflowPass.AssignmentEntry> sorted = new ArrayList<DataflowPass.AssignmentEntry>(killers);
        sorted.sort(Comparator.naturalOrder());
        sb.append(((DataflowPass.AssignmentEntry)sorted.get(0)).getLine());
        for (int i = 1; i < sorted.size() - 1; ++i) {
            sb.append(", ").append(((DataflowPass.AssignmentEntry)sorted.get(i)).getLine());
        }
        sb.append(" and ").append(((DataflowPass.AssignmentEntry)sorted.get(sorted.size() - 1)).getLine());
        return sb.toString();
    }
}

