/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;

public class JUnitUseExpectedRule
extends AbstractJavaRulechainRule {
    public JUnitUseExpectedRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTBlock body = node.getBody();
        if (body != null && TestFrameworksUtil.isJUnitMethod(node)) {
            body.descendants(ASTTryStatement.class).filter(this::isWeirdTry).forEach(it -> this.addViolation(data, (Node)it));
        }
        return null;
    }

    private boolean isWeirdTry(ASTTryStatement tryStmt) {
        ASTStatement lastStmt = (ASTStatement)tryStmt.getBody().getLastChild();
        return (lastStmt instanceof ASTThrowStatement || lastStmt instanceof ASTExpressionStatement && this.isFailStmt((ASTExpressionStatement)lastStmt)) && tryStmt.getCatchClauses().any(it -> it.getBody().size() == 0);
    }

    private boolean isFailStmt(ASTExpressionStatement stmt) {
        if (stmt.getExpr() instanceof ASTMethodCall) {
            ASTMethodCall expr = (ASTMethodCall)stmt.getExpr();
            return "fail".equals(expr.getMethodName());
        }
        return false;
    }
}

