/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.Map;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JavaViolationDecorator
implements ViolationDecorator {
    static final ViolationDecorator INSTANCE = new JavaViolationDecorator();

    JavaViolationDecorator() {
    }

    public void decorate(Node violationNode, Map<String, String> additionalInfo) {
        JavaNode javaNode = (JavaNode)violationNode;
        this.setIfNonNull("variableName", JavaViolationDecorator.getVariableNameIfExists(javaNode), additionalInfo);
        this.setIfNonNull("methodName", JavaViolationDecorator.getMethodName(javaNode), additionalInfo);
        this.setIfNonNull("className", this.getClassName(javaNode), additionalInfo);
        this.setIfNonNull("packageName", javaNode.getRoot().getPackageName(), additionalInfo);
    }

    private @Nullable String getClassName(JavaNode javaNode) {
        ASTAnyTypeDeclaration enclosing = null;
        if (javaNode instanceof ASTAnyTypeDeclaration) {
            enclosing = (ASTAnyTypeDeclaration)javaNode;
        }
        if (enclosing == null) {
            enclosing = javaNode.getEnclosingType();
        }
        if (enclosing == null) {
            enclosing = (ASTAnyTypeDeclaration)javaNode.getRoot().getTypeDeclarations().first(AccessNode::isPublic);
        }
        if (enclosing == null) {
            enclosing = (ASTAnyTypeDeclaration)javaNode.getRoot().getTypeDeclarations().first();
        }
        if (enclosing != null) {
            return enclosing.getSimpleName();
        }
        return null;
    }

    private void setIfNonNull(String key, String value, Map<String, String> additionalInfo) {
        if (value != null) {
            additionalInfo.put(key, value);
        }
    }

    private static @Nullable String getMethodName(@NonNull JavaNode javaNode) {
        @Nullable ASTBodyDeclaration enclosingDecl = (ASTBodyDeclaration)javaNode.ancestorsOrSelf().filterIs(ASTBodyDeclaration.class).first();
        if (enclosingDecl instanceof ASTMethodOrConstructorDeclaration) {
            return ((ASTMethodOrConstructorDeclaration)enclosingDecl).getName();
        }
        if (enclosingDecl instanceof ASTInitializer) {
            return ((ASTInitializer)enclosingDecl).isStatic() ? "<clinit>" : "<init>";
        }
        return null;
    }

    private static String getVariableNames(Iterable<ASTVariableDeclaratorId> iterable) {
        return IteratorUtil.toStream(iterable.iterator()).map(ASTVariableDeclaratorId::getName).collect(Collectors.joining(", "));
    }

    private static @Nullable String getVariableNameIfExists(JavaNode node) {
        if (node instanceof ASTFieldDeclaration) {
            return JavaViolationDecorator.getVariableNames((ASTFieldDeclaration)node);
        }
        if (node instanceof ASTLocalVariableDeclaration) {
            return JavaViolationDecorator.getVariableNames((ASTLocalVariableDeclaration)node);
        }
        if (node instanceof ASTVariableDeclarator) {
            return ((ASTVariableDeclarator)node).getVarId().getName();
        }
        if (node instanceof ASTVariableDeclaratorId) {
            return ((ASTVariableDeclaratorId)node).getName();
        }
        if (node instanceof ASTFormalParameter) {
            return JavaViolationDecorator.getVariableNameIfExists((JavaNode)node.firstChild(ASTVariableDeclaratorId.class));
        }
        if (node instanceof ASTExpression) {
            return JavaViolationDecorator.getVariableNameIfExists((JavaNode)node.getParent());
        }
        return null;
    }
}

