/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTRecordPattern;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaExpr;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AstImplUtil {
    private AstImplUtil() {
    }

    public static String getLastSegment(String nameWithDots, char sep) {
        assert (nameWithDots != null);
        int lastIdx = nameWithDots.lastIndexOf(sep);
        return lastIdx < 0 ? nameWithDots : nameWithDots.substring(lastIdx + 1);
    }

    public static String getFirstSegment(String nameWithDots, char sep) {
        assert (nameWithDots != null);
        int lastIdx = nameWithDots.indexOf(sep);
        return lastIdx < 0 ? nameWithDots : nameWithDots.substring(0, lastIdx);
    }

    public static <T extends Node> @Nullable T getChildAs(JavaNode javaNode, int idx, Class<T> type) {
        if (javaNode.getNumChildren() <= idx || idx < 0) {
            return null;
        }
        GenericNode child = javaNode.getChild(idx);
        return (T)(type.isInstance(child) ? (Node)type.cast(child) : null);
    }

    static void bumpParenDepth(ASTExpression expression) {
        assert (expression instanceof AbstractJavaExpr) : expression.getClass() + " doesn't have parenDepth attribute!";
        ((AbstractJavaExpr)expression).bumpParenDepth();
    }

    static void bumpParenDepth(ASTPattern pattern) {
        assert (pattern instanceof ASTTypePattern || pattern instanceof ASTRecordPattern) : pattern.getClass() + " doesn't have parenDepth attribute!";
        if (pattern instanceof ASTTypePattern) {
            ((ASTTypePattern)pattern).bumpParenDepth();
        } else if (pattern instanceof ASTRecordPattern) {
            ((ASTRecordPattern)pattern).bumpParenDepth();
        }
    }
}

