/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.math.BigInteger;
import java.util.Locale;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.AbstractLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTNumericLiteral
extends AbstractLiteral
implements ASTLiteral {
    private boolean isIntegral;

    ASTNumericLiteral(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    @Override
    public @NonNull Number getConstValue() {
        if (this.isIntegral()) {
            if (this.isIntLiteral()) {
                return this.getValueAsInt();
            }
            return this.getValueAsLong();
        }
        if (this.isFloatLiteral()) {
            return Float.valueOf(this.getValueAsFloat());
        }
        return this.getValueAsDouble();
    }

    @Override
    public @NonNull JPrimitiveType getTypeMirror() {
        return (JPrimitiveType)super.getTypeMirror();
    }

    void setIntLiteral() {
        this.isIntegral = true;
    }

    void setFloatLiteral() {
        this.isIntegral = false;
    }

    @Override
    public boolean isIntLiteral() {
        return this.isIntegral && !this.isLongLiteral();
    }

    @Override
    public boolean isLongLiteral() {
        if (this.isIntegral) {
            String image = this.getImage();
            char lastChar = image.charAt(image.length() - 1);
            return lastChar == 'l' || lastChar == 'L';
        }
        return false;
    }

    @Override
    public boolean isFloatLiteral() {
        if (!this.isIntegral) {
            String image = this.getImage();
            char lastChar = image.charAt(image.length() - 1);
            return lastChar == 'f' || lastChar == 'F';
        }
        return false;
    }

    @Override
    public boolean isDoubleLiteral() {
        return !this.isIntegral && !this.isFloatLiteral();
    }

    private String stripIntValue() {
        String image = this.getImage().toLowerCase(Locale.ROOT).replaceAll("_++", "");
        char last = image.charAt(image.length() - 1);
        if (last == 'l') {
            image = image.substring(0, image.length() - 1);
        }
        if (image.charAt(0) == '0' && image.length() > 1) {
            image = image.charAt(1) == 'x' || image.charAt(1) == 'b' ? image.substring(2) : image.substring(1);
        }
        return image;
    }

    private String stripFloatValue() {
        return this.getImage().replaceAll("_++", "");
    }

    public boolean isIntegral() {
        return this.isIntegral;
    }

    public int getBase() {
        String image = this.getImage();
        if (image.length() > 1 && image.charAt(0) == '0') {
            switch (image.charAt(1)) {
                case 'X': 
                case 'x': {
                    return 16;
                }
                case 'B': 
                case 'b': {
                    return 2;
                }
                case '.': {
                    return 10;
                }
            }
            return 8;
        }
        return 10;
    }

    public int getValueAsInt() {
        if (this.isIntegral) {
            return (int)this.getValueAsLong();
        }
        return (int)this.getValueAsDouble();
    }

    public long getValueAsLong() {
        if (this.isIntegral) {
            BigInteger bigInt = new BigInteger(this.stripIntValue(), this.getBase());
            return bigInt.longValue();
        }
        return (long)this.getValueAsDouble();
    }

    public float getValueAsFloat() {
        return this.isIntegral ? (float)this.getValueAsLong() : (float)this.getValueAsDouble();
    }

    public double getValueAsDouble() {
        return this.isIntegral ? (double)this.getValueAsLong() : Double.parseDouble(this.stripFloatValue());
    }
}

