/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTClassOrInterfaceType
extends AbstractJavaTypeNode
implements ASTReferenceType {
    private JTypeDeclSymbol symbol;
    private String simpleName;
    private boolean isFqcn;
    private JClassType implicitEnclosing;

    ASTClassOrInterfaceType(ASTAmbiguousName lhs, String simpleName) {
        super(37);
        assert (lhs != null) : "Null LHS";
        this.addChild(lhs, 0);
        this.simpleName = simpleName;
        this.assertSimpleNameOk();
    }

    ASTClassOrInterfaceType(ASTAmbiguousName simpleName) {
        super(37);
        this.simpleName = simpleName.getFirstToken().getImage();
        this.assertSimpleNameOk();
    }

    @Deprecated
    public ASTClassOrInterfaceType(String simpleName) {
        super(37);
        this.simpleName = simpleName;
    }

    ASTClassOrInterfaceType(@Nullable ASTClassOrInterfaceType lhs, boolean isFqcn, JavaccToken firstToken, JavaccToken identifier) {
        super(37);
        this.setImage(identifier.getImage());
        this.isFqcn = isFqcn;
        if (lhs != null) {
            this.addChild(lhs, 0);
        }
        this.setFirstToken(firstToken);
        this.setLastToken(identifier);
    }

    ASTClassOrInterfaceType(int id) {
        super(id);
    }

    @Override
    protected void setImage(String image) {
        this.simpleName = image;
        this.assertSimpleNameOk();
    }

    @Deprecated
    public String getImage() {
        return null;
    }

    private void assertSimpleNameOk() {
        assert (this.simpleName != null && this.simpleName.indexOf(46) < 0 && AssertionUtil.isJavaIdentifier((CharSequence)this.simpleName)) : "Invalid simple name '" + this.simpleName + "'";
    }

    public boolean isFullyQualified() {
        return this.isFqcn;
    }

    void setSymbol(JTypeDeclSymbol symbol) {
        this.symbol = symbol;
    }

    void setImplicitEnclosing(JClassType enclosing) {
        this.implicitEnclosing = enclosing;
    }

    JClassType getImplicitEnclosing() {
        return this.implicitEnclosing;
    }

    JTypeDeclSymbol getReferencedSym() {
        return this.symbol;
    }

    public @Nullable ASTClassOrInterfaceType getQualifier() {
        return (ASTClassOrInterfaceType)this.getFirstChildOfType(ASTClassOrInterfaceType.class);
    }

    public @Nullable ASTTypeArguments getTypeArguments() {
        return (ASTTypeArguments)this.getFirstChildOfType(ASTTypeArguments.class);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Deprecated
    public boolean isReferenceToClassSameCompilationUnit() {
        ASTCompilationUnit root = (ASTCompilationUnit)this.getFirstParentOfType(ASTCompilationUnit.class);
        for (ASTClassOrInterfaceDeclaration c : root.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class, true)) {
            if (!c.hasImageEqualTo(this.getImage())) continue;
            return true;
        }
        for (ASTEnumDeclaration e : root.findDescendantsOfType(ASTEnumDeclaration.class, true)) {
            if (!e.hasImageEqualTo(this.getImage())) continue;
            return true;
        }
        return false;
    }

    void setFullyQualified() {
        this.isFqcn = true;
    }
}

