/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.NameFinder;
import net.sourceforge.pmd.lang.java.symboltable.Search;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class OccurrenceFinder
extends JavaParserVisitorAdapter {
    private final Set<NameDeclaration> declarations = new HashSet<NameDeclaration>();
    private final Set<NameDeclaration> additionalDeclarations = new HashSet<NameDeclaration>();

    @Override
    public Object visit(ASTResource node, Object data) {
        if (node.getNumChildren() == 1) {
            ASTName nameNode = (ASTName)node.getChild(0);
            StringTokenizer st = new StringTokenizer(nameNode.getImage(), ".");
            while (st.hasMoreTokens()) {
                JavaNameOccurrence occ = new JavaNameOccurrence(nameNode, st.nextToken());
                new Search(occ).execute();
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        this.declarations.clear();
        this.additionalDeclarations.clear();
        List<JavaNameOccurrence> names = nameFinder.getNames();
        for (JavaNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (this.declarations.isEmpty()) {
                search.execute();
                this.declarations.addAll(search.getResult());
                if (!this.declarations.isEmpty()) continue;
                break;
            }
            for (NameDeclaration decl : this.declarations) {
                Scope startingScope = decl.getScope();
                if (decl instanceof VariableNameDeclaration) {
                    String typeImage = ((VariableNameDeclaration)decl).getTypeImage();
                    ClassNameDeclaration clazzDeclaration = ((SourceFileScope)startingScope.getEnclosingScope(SourceFileScope.class)).findClassNameDeclaration(typeImage);
                    if (clazzDeclaration != null) {
                        startingScope = clazzDeclaration.getScope();
                    }
                }
                search.execute(startingScope);
                Set<NameDeclaration> result = search.getResult();
                this.additionalDeclarations.addAll(result);
                if (!result.isEmpty()) continue;
                break;
            }
            this.declarations.addAll(this.additionalDeclarations);
        }
        return super.visit(node, data);
    }
}

