/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class ProperCloneImplementationRule
extends AbstractJavaRule {
    public ProperCloneImplementationRule() {
        this.addRuleChainVisit(ASTMethodDeclaration.class);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!"clone".equals(node.getName()) || node.getArity() > 0) {
            return data;
        }
        ASTBlock block = (ASTBlock)node.getFirstChildOfType(ASTBlock.class);
        if (block == null) {
            return data;
        }
        String enclosingClassName = ((ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)).getSimpleName();
        if (this.blockHasAllocations(block, enclosingClassName)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean blockHasAllocations(ASTBlock block, String enclosingClassName) {
        List allocations = block.findDescendantsOfType(ASTAllocationExpression.class);
        for (ASTAllocationExpression alloc : allocations) {
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)alloc.getFirstChildOfType(ASTClassOrInterfaceType.class);
            if (!type.hasImageEqualTo(enclosingClassName)) continue;
            return true;
        }
        return false;
    }
}

