/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;
import org.jaxen.JaxenException;

public class CloseResourceRule
extends AbstractJavaRule {
    private Set<String> types = new HashSet<String>();
    private Set<String> simpleTypes = new HashSet<String>();
    private Set<String> closeTargets = new HashSet<String>();
    private static final StringMultiProperty CLOSE_TARGETS_DESCRIPTOR = new StringMultiProperty("closeTargets", "Methods which may close this resource", new String[0], 1.0f, ',');
    private static final StringMultiProperty TYPES_DESCRIPTOR = new StringMultiProperty("types", "Affected types", new String[]{"java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet"}, 2.0f, ',');
    private static final BooleanProperty USE_CLOSE_AS_DEFAULT_TARGET = new BooleanProperty("closeAsDefaultTarget", "Consider 'close' as a target by default", true, 3.0f);

    public CloseResourceRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CLOSE_TARGETS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)TYPES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)USE_CLOSE_AS_DEFAULT_TARGET);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        if (this.closeTargets.isEmpty() && this.getProperty((PropertyDescriptor)CLOSE_TARGETS_DESCRIPTOR) != null) {
            this.closeTargets.addAll((Collection)this.getProperty((PropertyDescriptor)CLOSE_TARGETS_DESCRIPTOR));
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)USE_CLOSE_AS_DEFAULT_TARGET)).booleanValue() && !this.closeTargets.contains("close")) {
            this.closeTargets.add("close");
        }
        if (this.types.isEmpty() && this.getProperty((PropertyDescriptor)TYPES_DESCRIPTOR) != null) {
            this.types.addAll((Collection)this.getProperty((PropertyDescriptor)TYPES_DESCRIPTOR));
        }
        if (this.simpleTypes.isEmpty() && this.getProperty((PropertyDescriptor)TYPES_DESCRIPTOR) != null) {
            for (String type : (List)this.getProperty((PropertyDescriptor)TYPES_DESCRIPTOR)) {
                this.simpleTypes.add(CloseResourceRule.toSimpleType(type));
            }
        }
        return super.visit(node, data);
    }

    private static String toSimpleType(String fullyQualifiedClassName) {
        int lastIndexOf = fullyQualifiedClassName.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return fullyQualifiedClassName.substring(lastIndexOf + 1);
        }
        return fullyQualifiedClassName;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkForResources(node, data);
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkForResources(node, data);
        return data;
    }

    private void checkForResources(Node node, Object data) {
        List vars = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        ArrayList<ASTVariableDeclaratorId> ids = new ArrayList<ASTVariableDeclaratorId>();
        for (ASTLocalVariableDeclaration var : vars) {
            ASTClassOrInterfaceType clazz;
            ASTReferenceType ref;
            ASTType type = var.getTypeNode();
            if (!(type.jjtGetChild(0) instanceof ASTReferenceType) || !((ref = (ASTReferenceType)type.jjtGetChild(0)).jjtGetChild(0) instanceof ASTClassOrInterfaceType) || !((clazz = (ASTClassOrInterfaceType)ref.jjtGetChild(0)).getType() != null && this.types.contains(clazz.getType().getName()) || clazz.getType() == null && this.simpleTypes.contains(CloseResourceRule.toSimpleType(clazz.getImage())) && !clazz.isReferenceToClassSameCompilationUnit()) && (!this.types.contains(clazz.getImage()) || clazz.isReferenceToClassSameCompilationUnit())) continue;
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)var.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
            ids.add(id);
        }
        for (ASTVariableDeclaratorId x : ids) {
            this.ensureClosed((ASTLocalVariableDeclaration)x.jjtGetParent().jjtGetParent(), x, data);
        }
    }

    private boolean hasNullInitializer(ASTLocalVariableDeclaration var) {
        ASTVariableInitializer init = (ASTVariableInitializer)var.getFirstDescendantOfType(ASTVariableInitializer.class);
        if (init != null) {
            try {
                List nulls = init.findChildNodesWithXPath("Expression/PrimaryExpression/PrimaryPrefix/Literal/NullLiteral");
                return !nulls.isEmpty();
            }
            catch (JaxenException e) {
                return false;
            }
        }
        return false;
    }

    private void ensureClosed(ASTLocalVariableDeclaration var, ASTVariableDeclaratorId id, Object data) {
        String variableToClose = id.getImage();
        ASTLocalVariableDeclaration n = var;
        while (!(n instanceof ASTBlock) && !(n instanceof ASTConstructorDeclaration)) {
            n = n.jjtGetParent();
        }
        ASTLocalVariableDeclaration top = n;
        List tryblocks = top.findDescendantsOfType(ASTTryStatement.class);
        boolean closed = false;
        ASTBlockStatement parentBlock = (ASTBlockStatement)id.getFirstParentOfType(ASTBlockStatement.class);
        for (Object t : tryblocks) {
            ASTBlockStatement tryBlock = (ASTBlockStatement)t.getFirstParentOfType(ASTBlockStatement.class);
            if (!this.hasNullInitializer(var) && parentBlock.jjtGetParent() == tryBlock.jjtGetParent()) {
                List blocks = parentBlock.jjtGetParent().findChildrenOfType(ASTBlockStatement.class);
                int parentBlockIndex = blocks.indexOf(parentBlock);
                int tryBlockIndex = blocks.indexOf(tryBlock);
                boolean criticalStatements = false;
                for (int i = parentBlockIndex + 1; i < tryBlockIndex; ++i) {
                    ASTLocalVariableDeclaration varDecl = (ASTLocalVariableDeclaration)((ASTBlockStatement)blocks.get(i)).getFirstDescendantOfType(ASTLocalVariableDeclaration.class);
                    if (varDecl != null) continue;
                    criticalStatements = true;
                    break;
                }
                if (criticalStatements) break;
            }
            if (t.getBeginLine() <= id.getBeginLine() || !((ASTTryStatement)t).hasFinally()) continue;
            ASTBlock f = (ASTBlock)((ASTTryStatement)t).getFinally().jjtGetChild(0);
            List names = f.findDescendantsOfType(ASTName.class);
            for (ASTName oName : names) {
                String[] parts;
                String name = oName.getImage();
                if (name == null || !name.contains(".") || (parts = name.split("\\.")).length != 2) continue;
                String methodName = parts[1];
                String varName = parts[0];
                if (!varName.equals(variableToClose) || !this.closeTargets.contains(methodName) || !this.nullCheckIfCondition(f, oName, varName)) continue;
                closed = true;
                break;
            }
            if (closed) break;
            ArrayList exprs = new ArrayList();
            f.findDescendantsOfType(ASTStatementExpression.class, exprs, true);
            for (ASTStatementExpression stmt : exprs) {
                ASTPrimarySuffix oSuffix;
                String suff;
                ASTName prefixName;
                String prefixPlusSuffix;
                ASTPrimaryExpression expr = (ASTPrimaryExpression)stmt.getFirstChildOfType(ASTPrimaryExpression.class);
                if (expr == null) continue;
                ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)expr.getFirstChildOfType(ASTPrimaryPrefix.class);
                ASTPrimarySuffix suffix = (ASTPrimarySuffix)expr.getFirstChildOfType(ASTPrimarySuffix.class);
                if (prefix == null || suffix == null) continue;
                if (prefix.getImage() != null ? suffix.getImage() != null && this.closeTargets.contains(prefixPlusSuffix = prefix.getImage() + "." + suffix.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)) : (prefixName = (ASTName)prefix.getFirstChildOfType(ASTName.class)) != null && this.closeTargets.contains(prefixName.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose))) break;
                if (closed) continue;
                ArrayList suffixes = new ArrayList();
                expr.findDescendantsOfType(ASTPrimarySuffix.class, suffixes, true);
                Iterator iterator = suffixes.iterator();
                while (!(!iterator.hasNext() || this.closeTargets.contains(suff = (oSuffix = (ASTPrimarySuffix)iterator.next()).getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)))) {
                }
            }
            if (!closed) continue;
            break;
        }
        if (!closed) {
            ArrayList returns = new ArrayList();
            top.findDescendantsOfType(ASTReturnStatement.class, returns, true);
            for (ASTReturnStatement returnStatement : returns) {
                ASTName name = (ASTName)returnStatement.getFirstDescendantOfType(ASTName.class);
                if (name == null || !name.getImage().equals(variableToClose)) continue;
                closed = true;
                break;
            }
        }
        if (!closed) {
            ASTType type = (ASTType)var.getFirstChildOfType(ASTType.class);
            ASTReferenceType ref = (ASTReferenceType)type.jjtGetChild(0);
            ASTClassOrInterfaceType clazz = (ASTClassOrInterfaceType)ref.jjtGetChild(0);
            this.addViolation(data, id, clazz.getImage());
        }
    }

    private boolean variableIsPassedToMethod(ASTPrimaryExpression expr, String variable) {
        ArrayList methodParams = new ArrayList();
        expr.findDescendantsOfType(ASTName.class, methodParams, true);
        for (ASTName pName : methodParams) {
            String paramName = pName.getImage();
            ASTArgumentList parentParam = (ASTArgumentList)pName.getFirstParentOfType(ASTArgumentList.class);
            if (!paramName.equals(variable) || parentParam == null) continue;
            return true;
        }
        return false;
    }

    private ASTIfStatement findIfStatement(ASTBlock enclosingBlock, Node node) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.getFirstParentOfType(ASTIfStatement.class);
        List allIfStatements = enclosingBlock.findDescendantsOfType(ASTIfStatement.class);
        if (ifStatement != null && allIfStatements.contains(ifStatement)) {
            return ifStatement;
        }
        return null;
    }

    private boolean nullCheckIfCondition(ASTBlock enclosingBlock, Node node, String varName) {
        ASTIfStatement ifStatement = this.findIfStatement(enclosingBlock, node);
        if (ifStatement != null) {
            try {
                List nodes = ifStatement.findChildNodesWithXPath("Expression/EqualityExpression[@Image='!=']  [PrimaryExpression/PrimaryPrefix/Name[@Image='" + varName + "']]  [PrimaryExpression/PrimaryPrefix/Literal/NullLiteral]");
                return !nodes.isEmpty();
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

