/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class LocalScope
extends AbstractJavaScope {
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        NameDeclaration decl = this.findVariableHere(javaOccurrence);
        if (decl != null && !javaOccurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
            nameOccurrences.add(javaOccurrence);
            JavaNode n = javaOccurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    @Override
    public void addDeclaration(NameDeclaration nameDecl) {
        if (!(nameDecl instanceof VariableNameDeclaration) && !(nameDecl instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A LocalScope can contain only VariableNameDeclarations or ClassNameDeclarations. Tried to add " + nameDecl.getClass() + "(" + nameDecl + ")");
        }
        super.addDeclaration(nameDecl);
    }

    @Override
    public NameDeclaration findVariableHere(JavaNameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return null;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.getVariableDeclarations().keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        return "LocalScope:" + this.glomNames(this.getVariableDeclarations().keySet());
    }
}

