/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codesize;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.rule.codesize.AbstractNcssCountRule;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NcssTypeCountRule
extends AbstractNcssCountRule {
    public NcssTypeCountRule() {
        super(ASTTypeDeclaration.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 1500.0);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isNested()) {
            return super.visit(node, data);
        }
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTExplicitConstructorInvocation node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        if (node.jjtGetParent() instanceof ASTTypeDeclaration) {
            Integer nodeCount = this.countNodeChildren(node, data);
            int count = nodeCount - 1;
            return count;
        }
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTInitializer node, Object data) {
        return this.countNodeChildren((Node)node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{String.valueOf((int)point.getScore())};
    }
}

