/*
 * Copyright (c) 2012-2016 Snowflake Computing Inc. All right reserved.
 */

package net.snowflake.client.core;

import java.util.UUID;

/**
 * Utility class to encapsulate support information pertaining to the
 * EventHandler and events.
 * @author jrosen
 */
public class EventUtil
{
  public static final String DUMP_PATH_PROP = "snowflake.dump_path";
  public static final String DUMP_SIZE_PROP = "snowflake.max_dump_size";
  public static final String DUMP_SUBDIR = "snowflake_dumps";

  private static final String DUMP_FILE_ID = UUID.randomUUID().toString();
  private static final String DUMP_PATH_PREFIX =
      System.getProperty(DUMP_PATH_PROP) == null ?
      "/tmp" : System.getProperty(DUMP_PATH_PROP);
  private static final long MAX_DUMP_FILE_SIZE_BYTES =
      System.getProperty(DUMP_SIZE_PROP) == null ?
      (10 << 20) : Long.valueOf(System.getProperty(DUMP_SIZE_PROP));

  private static EventHandler eventHandler = null;

  /**
   * Initializes the common eventHandler instance for all sessions/threads
   * @param maxEntries - maximum number of buffered events before flush
   * @param flushPeriodMs - period of time between asynchronous buffer flushes
   */
  public static synchronized void initEventHandlerInstance(int maxEntries,
                                                           int flushPeriodMs)
  {
    if (eventHandler != null)
    {
      return;
    }

    eventHandler = new EventHandler(maxEntries, flushPeriodMs);
    //eventHandler.startFlusher();
  }

  /**
   * @return the shared EventHandler instance
   */
  public static EventHandler getEventHandlerInstance()
  {
    return eventHandler;
  }

  public static String getDumpPathPrefix()
  {
    return DUMP_PATH_PREFIX + "/" + DUMP_SUBDIR;
  }

  public static String getDumpFileId()
  {
    return DUMP_FILE_ID;
  }

  public static long getmaxDumpFileSizeBytes()
  {
    return MAX_DUMP_FILE_SIZE_BYTES;
  }
}
