/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import net.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import net.snowflake.client.jdbc.internal.apache.tika.io.IOExceptionWithCause;

public class TemporaryResources
implements Closeable {
    private final LinkedList<Closeable> resources = new LinkedList();
    private File tmp = null;

    public void setTemporaryFileDirectory(File tmp) {
        this.tmp = tmp;
    }

    public File createTemporaryFile() throws IOException {
        final File file = File.createTempFile("apache-tika-", ".tmp", this.tmp);
        this.addResource(new Closeable(){

            @Override
            public void close() throws IOException {
                if (!file.delete()) {
                    throw new IOException("Could not delete temporary file " + file.getPath());
                }
            }
        });
        return file;
    }

    public void addResource(Closeable resource) {
        this.resources.addFirst(resource);
    }

    public <T extends Closeable> T getResource(Class<T> klass) {
        for (Closeable resource : this.resources) {
            if (!klass.isAssignableFrom(resource.getClass())) continue;
            return (T)resource;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        LinkedList<IOException> exceptions = new LinkedList<IOException>();
        for (Closeable resource : this.resources) {
            try {
                resource.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        this.resources.clear();
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (IOException)exceptions.get(0);
            }
            throw new IOExceptionWithCause("Multiple IOExceptions" + exceptions, (Throwable)exceptions.get(0));
        }
    }

    public void dispose() throws TikaException {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new TikaException("Failed to close temporary resources", e);
        }
    }
}

