/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.entity;

import net.snowflake.client.jdbc.internal.apache.http.HttpException;
import net.snowflake.client.jdbc.internal.apache.http.HttpMessage;
import net.snowflake.client.jdbc.internal.apache.http.ProtocolException;
import net.snowflake.client.jdbc.internal.apache.http.annotation.Immutable;
import net.snowflake.client.jdbc.internal.apache.http.entity.ContentLengthStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

