/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.cookie;

import net.snowflake.client.jdbc.internal.apache.http.annotation.Immutable;
import net.snowflake.client.jdbc.internal.apache.http.cookie.Cookie;
import net.snowflake.client.jdbc.internal.apache.http.cookie.CookieOrigin;
import net.snowflake.client.jdbc.internal.apache.http.cookie.CookieRestrictionViolationException;
import net.snowflake.client.jdbc.internal.apache.http.cookie.MalformedCookieException;
import net.snowflake.client.jdbc.internal.apache.http.cookie.SetCookie;
import net.snowflake.client.jdbc.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import net.snowflake.client.jdbc.internal.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

