/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.metrics;

import net.snowflake.client.jdbc.internal.amazonaws.metrics.ServiceMetricType;
import net.snowflake.client.jdbc.internal.amazonaws.util.TimingInfo;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ServiceLatencyProvider {
    private final long startNano;
    private long endNano;
    private final ServiceMetricType serviceMetricType;

    public ServiceLatencyProvider(ServiceMetricType type) {
        this.endNano = this.startNano = System.nanoTime();
        this.serviceMetricType = type;
    }

    public ServiceMetricType getServiceMetricType() {
        return this.serviceMetricType;
    }

    public ServiceLatencyProvider endTiming() {
        if (this.endNano != this.startNano) {
            throw new IllegalStateException();
        }
        this.endNano = System.nanoTime();
        return this;
    }

    public double getDurationMilli() {
        if (this.endNano == this.startNano) {
            LogFactory.getLog(this.getClass()).debug("Likely to be a missing invocation of endTiming().");
        }
        return TimingInfo.durationMilliOf(this.startNano, this.endNano);
    }

    public String getProviderId() {
        return super.toString();
    }

    public String toString() {
        return String.format("providerId=%s, serviceMetricType=%s, startNano=%d, endNano=%d", this.getProviderId(), this.serviceMetricType, this.startNano, this.endNano);
    }
}

