/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.Response;
import net.snowflake.client.jdbc.internal.amazonaws.ServiceNameFactory;
import net.snowflake.client.jdbc.internal.amazonaws.auth.RegionAwareSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.SignerFactory;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.RequestHandler;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.RequestHandler2;
import net.snowflake.client.jdbc.internal.amazonaws.http.AmazonHttpClient;
import net.snowflake.client.jdbc.internal.amazonaws.http.ExecutionContext;
import net.snowflake.client.jdbc.internal.amazonaws.internal.DefaultServiceEndpointBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.log.CommonsLogFactory;
import net.snowflake.client.jdbc.internal.amazonaws.log.InternalLogFactory;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.AwsSdkMetrics;
import net.snowflake.client.jdbc.internal.amazonaws.metrics.RequestMetricCollector;
import net.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.Regions;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetrics;
import net.snowflake.client.jdbc.internal.amazonaws.util.AwsHostNameUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.Classes;
import net.snowflake.client.jdbc.internal.amazonaws.util.HttpUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public abstract class AmazonWebServiceClient {
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    public static final boolean LOGGING_AWS_REQUEST_METRIC = true;
    private static final Log log = LogFactory.getLog(AmazonWebServiceClient.class);
    protected volatile URI endpoint;
    private volatile String signerRegionOverride;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler2> requestHandler2s;
    protected int timeOffset;
    private volatile Signer signer;
    private volatile String serviceName;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector);
        this.requestHandler2s = new CopyOnWriteArrayList<RequestHandler2>();
    }

    protected Signer getSigner() {
        return this.signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        URI uri = this.toURI(endpoint);
        Signer signer = this.computeSignerByURI(uri, this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signer = signer;
        }
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        return HttpUtils.toUri(endpoint, this.clientConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String endpoint, String serviceName, String regionId) {
        URI uri = this.toURI(endpoint);
        Signer signer = this.computeSignerByServiceRegion(serviceName, regionId, regionId, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signer = signer;
            this.endpoint = uri;
            this.signerRegionOverride = regionId;
        }
    }

    @Deprecated
    protected void configSigner(URI uri) {
    }

    @Deprecated
    protected void configSigner(String serviceName, String regionId) {
    }

    public Signer getSignerByURI(URI uri) {
        return this.computeSignerByURI(uri, this.signerRegionOverride, true);
    }

    private Signer computeSignerByURI(URI uri, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        if (uri == null) {
            throw new IllegalArgumentException("Endpoint is not set. Use setEndpoint to set an endpoint before performing any request.");
        }
        String service = this.getServiceNameIntern();
        String region = AwsHostNameUtils.parseRegionName(uri.getHost(), service);
        return this.computeSignerByServiceRegion(service, region, signerRegionOverride, isRegionIdAsSignerParam);
    }

    private Signer computeSignerByServiceRegion(String serviceName, String regionId, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        Signer signer;
        String signerType = this.clientConfiguration.getSignerOverride();
        Signer signer2 = signer = signerType == null ? SignerFactory.getSigner(serviceName, regionId) : SignerFactory.getSignerByTypeAndService(signerType, serviceName);
        if (signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionAwareSigner = (RegionAwareSigner)signer;
            if (signerRegionOverride != null) {
                regionAwareSigner.setRegionName(signerRegionOverride);
            } else if (regionId != null && isRegionIdAsSignerParam) {
                regionAwareSigner.setRegionName(regionId);
            }
        }
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegion(Region region) throws IllegalArgumentException {
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String serviceNameForEndpoint = this.getServiceNameForRegionMetadata();
        String serviceNameForSigner = this.getServiceNameIntern();
        URI uri = new DefaultServiceEndpointBuilder(serviceNameForEndpoint, this.clientConfiguration.getProtocol().toString()).withRegion(region).getServiceEndpoint();
        Signer signer = this.computeSignerByServiceRegion(serviceNameForSigner, region.getName(), this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signer = signer;
        }
    }

    public final void configureRegion(Regions region) {
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        this.setRegion(Region.getRegion(region));
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.add(RequestHandler2.adapt(requestHandler));
    }

    public void addRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.add(requestHandler2);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.remove(RequestHandler2.adapt(requestHandler));
    }

    public void removeRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.remove(requestHandler2);
    }

    protected final <T extends AmazonWebServiceRequest> T beforeMarshalling(T request) {
        Object local = request;
        for (RequestHandler2 handler : this.requestHandler2s) {
            local = handler.beforeMarshalling((AmazonWebServiceRequest)local);
        }
        return local;
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req) || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, isMetricsEnabled, this);
    }

    protected final ExecutionContext createExecutionContext(Request<?> req) {
        return this.createExecutionContext(req.getOriginalRequest());
    }

    @Deprecated
    protected final ExecutionContext createExecutionContext() {
        boolean isMetricsEnabled = this.isRMCEnabledAtClientOrSdkLevel() || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, isMetricsEnabled, this);
    }

    protected static boolean isProfilingEnabled() {
        return System.getProperty("net.snowflake.client.jdbc.internal.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    protected final boolean isRequestMetricsEnabled(AmazonWebServiceRequest req) {
        RequestMetricCollector c = req.getRequestMetricCollector();
        if (c != null && c.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector c = this.requestMetricCollector();
        return c != null && c.isEnabled();
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public AmazonWebServiceClient withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector mc = this.client.getRequestMetricCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    protected final RequestMetricCollector findRequestMetricCollector(Request<?> req) {
        AmazonWebServiceRequest origReq = req.getOriginalRequest();
        RequestMetricCollector mc = origReq.getRequestMetricCollector();
        if (mc != null) {
            return mc;
        }
        mc = this.getRequestMetricsCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    protected final void endClientExecution(AWSRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response) {
        this.endClientExecution(awsRequestMetrics, request, response, false);
    }

    protected final void endClientExecution(AWSRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response, @Deprecated boolean loggingAwsRequestMetrics) {
        if (request != null) {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector c = this.findRequestMetricCollector(request);
            c.collectMetrics(request, response);
            awsRequestMetrics.log();
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    private String getServiceNameForRegionMetadata() {
        String httpClientName = this.getHttpClientName();
        String serviceNameInRegionMetadata = ServiceNameFactory.getServiceNameInRegionMetadata(httpClientName);
        if (serviceNameInRegionMetadata != null) {
            return serviceNameInRegionMetadata;
        }
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("The parameter serviceName must be specified!");
        }
        this.serviceName = serviceName;
    }

    private String computeServiceName() {
        int len;
        String httpClientName = this.getHttpClientName();
        String service = ServiceNameFactory.getServiceName(httpClientName);
        if (service != null) {
            return service;
        }
        int j = httpClientName.indexOf("JavaClient");
        if (j == -1 && (j = httpClientName.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + httpClientName);
        }
        int i = httpClientName.indexOf(AMAZON);
        if (i == -1) {
            i = httpClientName.indexOf(AWS);
            if (i == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + httpClientName);
            }
            len = AWS.length();
        } else {
            len = AMAZON.length();
        }
        if (i >= j) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + httpClientName);
        }
        String serviceName = httpClientName.substring(i + len, j);
        return serviceName.toLowerCase();
    }

    private String getHttpClientName() {
        Class<?> httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, this);
        return httpClientClass.getSimpleName();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String signerRegionOverride) {
        Signer signer = this.computeSignerByURI(this.endpoint, signerRegionOverride, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signer = signer;
            this.signerRegionOverride = signerRegionOverride;
        }
    }

    public <T extends AmazonWebServiceClient> T withRegion(Region region) {
        this.setRegion(region);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    public <T extends AmazonWebServiceClient> T withRegion(Regions region) {
        this.configureRegion(region);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    public <T extends AmazonWebServiceClient> T withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    static {
        boolean success = InternalLogFactory.configureFactory(new CommonsLogFactory());
        if (log.isDebugEnabled()) {
            log.debug("Internal logging succesfully configured to commons logger: " + success);
        }
    }
}

