/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFFixedViewResultSet;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementMetaData;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SFStatement.class);
    private SFSession session;
    Map<String, Map<String, Object>> parameterBindings = new HashMap<String, Map<String, Object>>();
    private SFBaseResultSet resultSet = null;
    private SFBaseResultSet currentResultSet = null;
    private HttpRequestBase httpRequest;
    private int updateCount = -1;
    private Boolean isClosed = false;
    private Integer sequenceId = -1;
    private String requestId = null;
    private String sqlText = null;
    private AtomicBoolean canceling = new AtomicBoolean(false);
    private int queryTimeout = 0;
    private boolean isFileTransfer = false;
    private SnowflakeFileTransferAgent transferAgent = null;
    Map<String, Object> statementParametersMap = new HashMap<String, Object>();
    private static final int MAX_STATEMENT_PARAMETERS = 1000;
    private String sql = null;

    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        this.statementParametersMap.put(propertyName, propertyValue);
        if ("query_timeout".equalsIgnoreCase(propertyName)) {
            this.queryTimeout = (Integer)propertyValue;
        }
        if (this.statementParametersMap.size() > 1000) {
            throw new SFException(ErrorCode.TOO_MANY_STATEMENT_PARAMETERS, 1000);
        }
    }

    public SFStatement(SFSession session) {
        this(session, null);
        logger.debug(" public SFStatement(SFSession session)");
    }

    public SFStatement(SFSession session, String sql) {
        logger.debug(" public SFStatement(SFSession session, String sql)");
        this.session = session;
        this.sql = sql;
    }

    void sanityCheckQuery(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw new SnowflakeSQLException("03000", ErrorCode.INVALID_SQL.getMessageCode(), sql);
        }
    }

    protected SFBaseResultSet executeQuery(String sql) throws SQLException, SFException {
        return this.executeQuery(sql, false);
    }

    protected SFBaseResultSet executeQuery(String sql, boolean describeOnly) throws SQLException, SFException {
        this.sanityCheckQuery(sql);
        String trimmedSql = sql.trim();
        if (this.isFileTransfer(trimmedSql)) {
            logger.debug("Executing file transfer locally: {}", sql);
            return this.executeFileTransfer(sql);
        }
        return this.executeQueryInternal(sql, this.parameterBindings, describeOnly);
    }

    public SFStatementMetaData describe(String sql) throws SFException, SQLException {
        SFBaseResultSet baseResultSet = this.executeQuery(sql, true);
        return new SFStatementMetaData(baseResultSet.getMetaData(), baseResultSet.getNumberOfBinds());
    }

    public SFStatementMetaData describe() throws SFException, SQLException {
        return this.describe(this.sql);
    }

    protected SFBaseResultSet executeQueryInternal(String sql, Map<String, Map<String, Object>> parameterBindings, boolean describeOnly) throws SQLException, SFException {
        this.resetState();
        if (logger.isDebugEnabled()) {
            logger.debug("Time: {} executeQuery: {}", System.currentTimeMillis(), sql);
        }
        if (this.session.isClosed()) {
            throw new SQLException("connection is closed");
        }
        Object result = this.executeHelper(sql, "application/snowflake", parameterBindings, describeOnly);
        if (result == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "got null result");
        }
        boolean sortResult = false;
        Object sortProperty = this.session.getSFSessionProperty("sort");
        boolean bl = sortResult = sortProperty != null && (Boolean)sortProperty != false;
        if (logger.isDebugEnabled()) {
            logger.debug("Time: {} Creating result set", System.currentTimeMillis());
        }
        try {
            this.resultSet = new SFResultSet((JsonNode)result, this, sortResult);
        }
        catch (SnowflakeSQLException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.error("Exception creating result", ex);
            throw IncidentUtil.generateIncidentWithException(this.session, null, null, ex, ErrorCode.INTERNAL_ERROR, "exception creating result");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Time: {} Done creating result set", System.currentTimeMillis());
        }
        return this.resultSet;
    }

    private void setTimeBomb(ScheduledExecutorService executor) {
        class TimeBombTask
        implements Callable<Void> {
            final SFStatement statement;

            TimeBombTask(SFStatement statement) {
                this.statement = statement;
            }

            @Override
            public Void call() throws SQLException {
                try {
                    this.statement.cancel();
                }
                catch (SFException ex) {
                    throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
                }
                return null;
            }
        }
        executor.schedule(new TimeBombTask(this), (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeHelper(String sql, String mediaType, Map<String, Map<String, Object>> bindValues, boolean describeOnly) throws SnowflakeSQLException, SFException {
        ExecutorService executor = null;
        try {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.isClosed.booleanValue()) {
                    throw new SFException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
                }
                if (this.canceling.get()) {
                    throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
                }
                if (this.requestId != null) {
                    throw new SnowflakeSQLException("0A000", ErrorCode.STATEMENT_ALREADY_RUNNING_QUERY.getMessageCode());
                }
                this.requestId = UUID.randomUUID().toString();
                this.sequenceId = this.session.getAndIncrementSequenceId();
                this.sqlText = sql;
            }
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_STARTED, String.format(BasicEvent.QueryState.QUERY_STARTED.getArgString(), this.requestId));
            StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
            stmtInput.setSql(sql).setMediaType(mediaType).setBindValues(bindValues).setDescribeOnly(describeOnly).setServerUrl(this.session.getServerUrl()).setRequestId(this.requestId).setSequenceId(this.sequenceId).setParametersMap(this.statementParametersMap).setSessionToken(this.session.getSessionToken()).setHttpClient(this.session.getHttpClient()).setNetworkTimeoutInMillis(this.session.getNetworkTimeoutInMilli()).setInjectSocketTimeout(this.session.getInjectSocketTimeout()).setInjectClientPause(this.session.getInjectClientPause()).setCanceling(this.canceling).setRetry(false);
            if (this.canceling.get()) {
                logger.debug("Query cancelled");
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            if (this.queryTimeout > 0) {
                executor = Executors.newScheduledThreadPool(1);
                this.setTimeBomb((ScheduledExecutorService)executor);
            }
            StmtUtil.StmtOutput stmtOutput = null;
            boolean sessionRenewed = false;
            while (true) {
                sessionRenewed = false;
                try {
                    stmtOutput = StmtUtil.execute(stmtInput);
                }
                catch (SnowflakeSQLException ex) {
                    if (ex.getErrorCode() != 390112) {
                        throw ex;
                    }
                    this.session.renewSession(stmtInput.sessionToken);
                    stmtInput.setSessionToken(this.session.getSessionToken());
                    stmtInput.setRetry(true);
                    sessionRenewed = true;
                    logger.debug("Session got renewed, will retry");
                    if (sessionRenewed && !this.canceling.get()) continue;
                }
                break;
            }
            if (System.getProperty("snowflake.enable_incident_test1") != null && System.getProperty("snowflake.enable_incident_test1").equals("true")) {
                SFException sfe = IncidentUtil.generateIncidentWithException(this.session, this.requestId, null, ErrorCode.STATEMENT_CLOSED, new Object[0]);
                throw sfe;
            }
            Object object = this;
            synchronized (object) {
                this.sequenceId = -1;
                this.requestId = null;
            }
            if (this.canceling.get()) {
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Time: {} Returning from executeHelper", System.currentTimeMillis());
            }
            object = stmtOutput.getResult();
            return object;
        }
        catch (SFException | SnowflakeSQLException ex) {
            this.isClosed = true;
            throw ex;
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelHelper(String sql, String mediaType) throws SnowflakeSQLException, SFException {
        SFStatement sFStatement = this;
        synchronized (sFStatement) {
            if (this.isClosed.booleanValue()) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "statement already closed");
            }
        }
        StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
        stmtInput.setServerUrl(this.session.getServerUrl()).setSql(sql).setMediaType(mediaType).setRequestId(this.requestId).setHttpClient(this.session.getHttpClient()).setSessionToken(this.session.getSessionToken());
        StmtUtil.cancel(stmtInput);
        SFStatement sFStatement2 = this;
        synchronized (sFStatement2) {
            this.sequenceId = -1;
            this.requestId = null;
        }
    }

    protected void releaseConnection() {
        logger.debug("public void releaseConnection()");
        if (this.httpRequest != null) {
            logger.debug("Release connection");
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
    }

    protected boolean isFileTransfer(String sql) {
        if (sql == null) {
            return false;
        }
        String trimmedSql = sql.trim();
        while (trimmedSql.startsWith("//")) {
            logger.debug("skipping // comments in: \n{}", trimmedSql);
            if (trimmedSql.indexOf(10) <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf(10));
            trimmedSql = trimmedSql.trim();
            logger.debug("New sql after skipping // comments: \n{}", trimmedSql);
        }
        while (trimmedSql.startsWith("/*")) {
            logger.debug("skipping /* */ comments in: \n{}", trimmedSql);
            if (trimmedSql.indexOf("*/") <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf("*/") + 2);
            trimmedSql = trimmedSql.trim();
            logger.debug("New sql after skipping /* */ comments: \n{}", trimmedSql);
        }
        return trimmedSql.length() >= 4 && (trimmedSql.toLowerCase().startsWith("put ") || trimmedSql.toLowerCase().startsWith("get "));
    }

    public SFBaseResultSet execute(String sql) throws SQLException, SFException {
        this.sanityCheckQuery(sql);
        this.session.injectedDelay();
        logger.debug("execute: {}", sql);
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return null;
        }
        return this.executeQuery(sql);
    }

    protected SFBaseResultSet executeFileTransfer(String sql) throws SQLException, SFException {
        this.session.injectedDelay();
        this.resetState();
        logger.debug("Entering executeFileTransfer");
        this.isFileTransfer = true;
        this.transferAgent = new SnowflakeFileTransferAgent(sql, this.session, this);
        try {
            this.transferAgent.execute();
            logger.debug("setting result set");
            this.resultSet = (SFFixedViewResultSet)this.transferAgent.getResultSet();
            logger.debug("Number of cols: {}", this.resultSet.getMetaData().getColumnCount());
            return this.resultSet;
        }
        catch (SQLException ex) {
            logger.debug("Exception: {}", ex.getMessage());
            throw ex;
        }
    }

    private int getQueryTimeout() throws SQLException {
        logger.debug("public int getQueryTimeout()");
        return this.queryTimeout;
    }

    private SFBaseResultSet getResultSet() throws SQLException {
        logger.debug("public ResultSet getResultSet()");
        if (this.currentResultSet == null) {
            this.currentResultSet = this.resultSet;
            this.resultSet = null;
        }
        return this.currentResultSet;
    }

    public void close() throws SQLException {
        logger.debug("public void close()");
        if (this.requestId != null) {
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_ENDED, String.format(BasicEvent.QueryState.QUERY_ENDED.getArgString(), this.requestId));
        }
        this.currentResultSet = null;
        this.resultSet = null;
        this.isClosed = true;
        if (this.httpRequest != null) {
            logger.debug("releasing connection for the http request");
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SFException, SQLException {
        logger.debug("public void cancel()");
        if (this.canceling.get()) {
            logger.debug("Query is already cancelled");
            return;
        }
        this.canceling.set(true);
        if (this.isFileTransfer) {
            if (this.transferAgent != null) {
                logger.debug("Cancel file transferring ... ");
                this.transferAgent.cancel();
            }
        } else {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.requestId == null) {
                    logger.debug("No remote query outstanding");
                    return;
                }
            }
            this.cancelHelper(this.sqlText, "application/snowflake");
        }
    }

    private void resetState() {
        this.resultSet = null;
        this.currentResultSet = null;
        if (this.httpRequest != null) {
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        this.isClosed = false;
        this.updateCount = -1;
        this.sequenceId = -1;
        this.requestId = null;
        this.sqlText = null;
        this.canceling.set(false);
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    public void executeSetProperty(String sql) {
        logger.debug("setting property");
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("sort".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3 && "on".equalsIgnoreCase(tokens[2])) {
                logger.debug("setting sort on");
                this.session.setSFSessionProperty("sort", true);
            } else {
                logger.debug("setting sort off");
                this.session.setSFSessionProperty("sort", false);
            }
        }
    }

    public void setValues(String parameterName, List<String> values, String sqlType) {
        HashMap<String, Object> newBindingValueAndType = new HashMap<String, Object>();
        newBindingValueAndType.put("value", values);
        newBindingValueAndType.put("type", sqlType);
        this.parameterBindings.put(parameterName, newBindingValueAndType);
    }

    public void setValue(String parameterName, String value, String sqlType) {
        HashMap<String, String> newBindingValueAndType = new HashMap<String, String>();
        newBindingValueAndType.put("value", value);
        newBindingValueAndType.put("type", sqlType);
        this.parameterBindings.put(parameterName, newBindingValueAndType);
    }

    protected SFSession getSession() {
        return this.session;
    }
}

