/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.sf.sfac.gui.editor.cmp.ComboBoxEditorModel;

public class VariableComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ComboBoxEditorModel {
    private Object[] availableValues;
    private int selectedIndex;

    public VariableComboBoxModel(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Values cannot be empty");
        }
        this.availableValues = values;
    }

    public void setAvailableValues(Object[] values) {
        if (values != this.availableValues) {
            if (values == null) {
                values = new Object[]{};
            }
            Object selectedItem = this.getSelectedItem();
            this.availableValues = values;
            int oldIndex = this.selectedIndex;
            this.selectedIndex = this.getItemIndex(selectedItem);
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
            if (oldIndex != this.selectedIndex) {
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    private int getItemIndex(Object anItem) {
        int index;
        int len = this.availableValues.length;
        int n = index = len == 0 ? -1 : 0;
        if (anItem != null) {
            for (int i = 0; i < len; ++i) {
                if (!anItem.equals(this.availableValues[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public int getSize() {
        return this.availableValues.length;
    }

    public Object getElementAt(int index) {
        return this.availableValues[index];
    }

    public void setSelectedItem(Object anItem) {
        if (this.getSelectedItem() != anItem) {
            int oldIndex = this.selectedIndex;
            this.selectedIndex = this.getItemIndex(anItem);
            if (oldIndex != this.selectedIndex) {
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    public Object getSelectedItem() {
        return this.selectedIndex < 0 ? null : this.availableValues[this.selectedIndex];
    }

    public void fireAllDataChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

