/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeHelper {
    private static final PathSorter PATH_SORTER = new PathSorter();

    public static void expandAllNodesToLevel(JTree tree, TreePath pathToLevel) {
        int level;
        int n = level = pathToLevel == null ? 0 : pathToLevel.getPathCount();
        if (level > 1) {
            TreePath currentPath = new TreePath(tree.getModel().getRoot());
            TreeHelper.expandNodesOfLevels(tree, currentPath, level);
        }
    }

    public static void expandChildNodes(JTree tree, TreePath pathToNone) {
        TreeHelper.expandNodesOfLevels(tree, pathToNone, Integer.MAX_VALUE);
    }

    public static void expandAll(JTree tree) {
        TreePath rootPath = new TreePath(tree.getModel().getRoot());
        TreeHelper.expandNodesOfLevels(tree, rootPath, Integer.MAX_VALUE);
    }

    public static void collapseAllNodesFromLevel(JTree tree, TreePath pathToLevel) {
        int level;
        int n = level = pathToLevel == null ? -1 : pathToLevel.getPathCount() - 1;
        if (level >= 1) {
            TreePath rootPath = new TreePath(tree.getModel().getRoot());
            TreeHelper.collapseNodesOfLevels(tree, rootPath, level);
        }
    }

    public static void collapseChildNodes(JTree tree, TreePath pathToNone) {
        TreeHelper.collapseNodesOfLevels(tree, pathToNone, 1);
    }

    public static void collapseAll(JTree tree) {
        TreePath rootPath = new TreePath(tree.getModel().getRoot());
        TreeHelper.collapseNodesOfLevels(tree, rootPath, 1);
    }

    private static void expandNodesOfLevels(JTree tree, TreePath currentPath, int toLevel) {
        int currentLevel = currentPath.getPathCount();
        if (currentLevel < toLevel) {
            if (tree.isCollapsed(currentPath)) {
                tree.expandPath(currentPath);
                TreeHelper.collapseChildNodes(tree, currentPath);
                tree.expandPath(currentPath);
            }
            Object currentNode = currentPath.getLastPathComponent();
            TreeModel model = tree.getModel();
            int len = model.getChildCount(currentNode);
            for (int i = 0; i < len; ++i) {
                RecursiveTreePath childPath = new RecursiveTreePath(currentPath, model.getChild(currentNode, i));
                TreeHelper.expandNodesOfLevels(tree, childPath, toLevel);
            }
        }
    }

    private static void collapseNodesOfLevels(JTree tree, TreePath basePath, int fromLevel) {
        Enumeration<TreePath> expandedEnum = tree.getExpandedDescendants(basePath);
        if (expandedEnum != null) {
            ArrayList<TreePath> expandedList = new ArrayList<TreePath>();
            while (expandedEnum.hasMoreElements()) {
                expandedList.add(expandedEnum.nextElement());
            }
            Collections.sort(expandedList, PATH_SORTER);
            int len = expandedList.size();
            for (int i = 0; i < len; ++i) {
                TreePath path = (TreePath)expandedList.get(i);
                int level = path.getPathCount();
                if (level <= fromLevel) continue;
                tree.collapsePath(path);
            }
        }
    }

    public static void registerHelperListener(final JTree tree) {
        tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvt) {
                TreePath path;
                if (mouseEvt.getButton() == 3 && (path = tree.getPathForLocation(mouseEvt.getX(), mouseEvt.getY())) != null) {
                    tree.setSelectionPath(path);
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem expandAllItem = new JMenuItem("Expand All");
                    expandAllItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.expandAll(tree);
                        }
                    });
                    popup.add(expandAllItem);
                    JMenuItem expandChildItem = new JMenuItem("Expand Children");
                    expandChildItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.expandChildNodes(tree, path);
                        }
                    });
                    popup.add(expandChildItem);
                    JMenuItem expandLevelItem = new JMenuItem("Expand To This Level");
                    expandLevelItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.expandAllNodesToLevel(tree, path);
                        }
                    });
                    popup.add(expandLevelItem);
                    JMenuItem collapseAllItem = new JMenuItem("Collapse All");
                    collapseAllItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.collapseAll(tree);
                        }
                    });
                    popup.add(collapseAllItem);
                    JMenuItem collapseChildItem = new JMenuItem("Collapse Children");
                    collapseChildItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.collapseChildNodes(tree, path);
                        }
                    });
                    popup.add(collapseChildItem);
                    JMenuItem collapseLevelItem = new JMenuItem("Collapse To This Level");
                    collapseLevelItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHelper.collapseAllNodesFromLevel(tree, path);
                        }
                    });
                    popup.add(collapseLevelItem);
                    popup.show(tree, mouseEvt.getX(), mouseEvt.getY());
                }
            }
        });
    }

    public static class RecursiveTreePath
    extends TreePath {
        public RecursiveTreePath(TreePath parent, Object node) {
            super(parent, node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PathSorter
    implements Comparator<TreePath> {
        PathSorter() {
        }

        @Override
        public int compare(TreePath path1, TreePath path2) {
            int len2;
            if (path1 == path2) {
                return 0;
            }
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            int len1 = path1.getPathCount();
            if (len1 != (len2 = path2.getPathCount())) {
                return len1 < len2 ? 1 : -1;
            }
            return 0;
        }
    }
}

