/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class IconArrayCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Icon[] icons;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setEnabled(table.isEnabled());
        this.icons = (Icon[])value;
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = NO_FOCUS_BORDER;
        }
        this.setBorder(border);
        return this;
    }

    protected void paintComponent(Graphics g) {
        Color oldCol = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(oldCol);
        if (this.icons != null) {
            int posX = 2;
            int posY = 2;
            for (Icon ico : this.icons) {
                ico.paintIcon(this, g, posX, posY);
                posX += ico.getIconWidth() + 2;
            }
        }
    }
}

