/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.sfac.file.FileType;
import net.sf.sfac.file.FileUtils;
import net.sf.sfac.gui.SystemDialog;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDropListener
implements DropTargetListener {
    private static Log log = LogFactory.getLog(FileDropListener.class);
    private static final String[] OPTIONS_FOR_DROP = new String[]{"OVERRIDE", "RENAME", "CANCEL"};
    private FileDropTarget target;
    private int acceptableActions;
    private int currentAction;
    private List<FileType> acceptedFiles;
    private boolean isAccepted = false;

    public FileDropListener(FileDropTarget fileDropTarget, FileType ... acceptedFileType) {
        this(fileDropTarget, 3, acceptedFileType);
    }

    public FileDropListener(FileDropTarget fileDropTarget, int acceptedActions, FileType ... acceptedFileType) {
        this.target = fileDropTarget;
        this.acceptedFiles = new ArrayList<FileType>();
        if (acceptedFileType != null) {
            for (FileType type : acceptedFileType) {
                this.acceptedFiles.add(type);
            }
        }
        this.acceptableActions = acceptedActions;
    }

    public List<FileType> getAcceptedFileType() {
        return this.acceptedFiles;
    }

    public void setAcceptedFileType(List<FileType> fileTypes) {
        if (fileTypes == null) {
            throw new IllegalArgumentException("fileTypes cannot be null");
        }
        this.acceptedFiles = fileTypes;
    }

    public void addAcceptedFileType(FileType addedType) {
        this.acceptedFiles.add(addedType);
    }

    public void registerToComponent(Component cmp) {
        cmp.setDropTarget(new DropTarget(cmp, this));
        if (cmp instanceof Container) {
            Container cnt = (Container)cmp;
            int len = cnt.getComponentCount();
            for (int i = 0; i < len; ++i) {
                this.registerToComponent(cnt.getComponent(i));
            }
        }
    }

    public static void executeDropAction(int dropAction, File sourceFile, File targetFile, File existingFile, Component parent) throws IOException {
        boolean continueAction = true;
        if (existingFile != null) {
            Object[] params = new Object[]{existingFile.getAbsolutePath()};
            int res = SystemDialog.showDialog(parent, "DROP_OVERRIDE", "DROP_OVERRIDE_FILE", params, OPTIONS_FOR_DROP, "RENAME", 2);
            if (res == -1 || res == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rename existing image file: " + existingFile));
                }
                FileUtils.renameToBackup((File)existingFile);
            } else if (res == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete existing image file: " + existingFile));
                }
                FileUtils.deleteFile((File)existingFile);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Image drop cancelled by user");
                }
                continueAction = false;
            }
        } else {
            FileUtils.ensureParentDirectoryExists((File)targetFile);
        }
        if (continueAction) {
            if (dropAction == 2) {
                FileUtils.moveFile((File)sourceFile, (File)targetFile);
            } else if (dropAction == 1) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            } else {
                throw new IllegalArgumentException("Unknown drop action: " + dropAction);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.currentAction = dtde.getDropAction();
        boolean bl = this.isAccepted = (this.currentAction & this.acceptableActions) != 0 && dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        if (this.isAccepted) {
            dtde.acceptDrag(this.currentAction);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isAccepted) {
            dtde.acceptDrag(this.currentAction);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.dragEnter(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.currentAction = 0;
        this.isAccepted = false;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DropTargetContext targetContext = dtde.getDropTargetContext();
        List droppedFiles = null;
        if ((dtde.getSourceActions() & this.currentAction) != 0) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(this.currentAction);
                try {
                    Transferable t = dtde.getTransferable();
                    droppedFiles = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    log.error((Object)"Cannot convert dropped object to File[]", (Throwable)e);
                }
            } else {
                log.warn((Object)"Flavor 'javaFileListFlavor' not available in DropTargetDropEvent");
                dtde.rejectDrop();
            }
        } else {
            log.warn((Object)("Current action (" + this.currentAction + ") not available in DropTargetDropEvent source actions (" + dtde.getSourceActions() + ")"));
            dtde.rejectDrop();
        }
        if (droppedFiles != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notify dropped file list: " + droppedFiles));
            }
            targetContext.dropComplete(true);
            File[] fileArray = this.getFilteredFiles(droppedFiles);
            if (fileArray.length > 0) {
                this.target.filesDropped(fileArray, this.currentAction);
            } else {
                log.warn((Object)("Filtered file lis is empty (for " + droppedFiles.size() + " files dropped)"));
            }
        } else {
            targetContext.dropComplete(false);
        }
        this.currentAction = 0;
        this.isAccepted = false;
    }

    private File[] getFilteredFiles(List<File> droppedFiles) {
        List<File> filteredFiles;
        if (Comparison.isEmpty(this.acceptedFiles)) {
            filteredFiles = droppedFiles;
        } else {
            filteredFiles = new ArrayList<File>();
            for (File dropped : droppedFiles) {
                if (!this.isAccepted(dropped)) continue;
                filteredFiles.add(dropped);
            }
        }
        return filteredFiles.toArray(new File[filteredFiles.size()]);
    }

    private boolean isAccepted(File fil) {
        boolean accepted = false;
        for (FileType type : this.acceptedFiles) {
            if (!type.accept(fil)) continue;
            accepted = true;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("   - Dropped file: " + fil + " --> accepted = " + accepted));
        }
        return accepted;
    }

    public static interface FileDropTarget {
        public void filesDropped(File[] var1, int var2);
    }
}

