/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import net.sf.sfac.gui.utils.ComboBoxKeyManager;
import net.sf.sfac.gui.utils.VariableComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboCellEditor
extends JComboBox
implements TableCellEditor {
    private List<CellEditorListener> listenerList = new ArrayList<CellEditorListener>();

    public ComboCellEditor(ComboBoxModel model) {
        super(model);
        this.setKeySelectionManager(new ComboBoxKeyManager());
        this.registerListeners();
    }

    public ComboCellEditor(Class<? extends Enum<?>> displayedClass) {
        super(new VariableComboBoxModel(displayedClass.getEnumConstants()));
        this.registerListeners();
    }

    private void registerListeners() {
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent newE) {
                ComboCellEditor.this.stopCellEditing();
            }

            public void focusGained(FocusEvent newE) {
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(l);
    }

    protected void fireEditingStopped() {
        int len = this.listenerList.size();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < len; ++i) {
            this.listenerList.get(i).editingStopped(changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        int len = this.listenerList.size();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < len; ++i) {
            this.listenerList.get(i).editingCanceled(changeEvent);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.listenerList.clear();
        this.getModel().setSelectedItem(value);
        return this;
    }
}

