/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.utils;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import net.sf.sfac.string.StringUtils;

public class ComboBoxKeyManager
implements JComboBox.KeySelectionManager {
    private static long TIME_DIFF = 1500L;
    private long lastKeyTimestamp;
    private String stringStart;

    public int selectionForKey(char aKey, ComboBoxModel model) {
        String cmpString = this.getStringStart(aKey);
        if (aKey == '\u007f' || aKey == '\b') {
            model.setSelectedItem(null);
        } else {
            int len = model.getSize();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    String str;
                    Object element = model.getElementAt(i);
                    String string = str = element == null ? null : element.toString();
                    if (!ComboBoxKeyManager.startsWithFormatted(str, cmpString)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public String getStringStart(char aKey) {
        long curTime = System.currentTimeMillis();
        if (aKey < ' ' || aKey == '\u007f') {
            this.stringStart = "";
        } else {
            aKey = ComboBoxKeyManager.formatChar(aKey);
            this.stringStart = curTime - this.lastKeyTimestamp < TIME_DIFF ? this.stringStart + aKey : String.valueOf(aKey);
        }
        this.lastKeyTimestamp = curTime;
        return this.stringStart;
    }

    public static boolean startsWithFormatted(String tested, String prefix) {
        int len = prefix.length();
        if (len == 0) {
            return true;
        }
        if (tested == null || len > tested.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (ComboBoxKeyManager.formatChar(tested.charAt(i)) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static char formatChar(char aKey) {
        aKey = StringUtils.removeDiacritic((char)aKey);
        aKey = Character.toUpperCase(aKey);
        return aKey;
    }
}

