/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableColumnSizer
implements Runnable {
    private static final Log log = LogFactory.getLog(TableColumnSizer.class);
    private static final int ROW_BATCH_SIZE = 100;
    private static final int SLEEP_TIME = 0;
    private static final int DEFAULT_PADDING = 10;
    private JTable table;
    private int currentRow;
    private int totalPreferredWidth;
    private int[] columnPreferredWidths;
    private boolean continueSizeCheck;
    private Thread checkingThread;
    private int defaultColumnPadding = 10;
    private int[] columnPaddings;

    public TableColumnSizer(JTable theTable) {
        this.table = theTable;
    }

    public void setDefaultColumnPadding(int inset) {
        this.defaultColumnPadding = inset;
    }

    public int getDefaultColumnPadding() {
        return this.defaultColumnPadding;
    }

    public void setColumnPaddings(int[] insets) {
        this.columnPaddings = insets;
    }

    public int[] getColumnPaddings() {
        return (int[])this.columnPaddings.clone();
    }

    public void startColumnSizing() {
        this.table.setAutoResizeMode(0);
        this.totalPreferredWidth = 0;
        int nbrColumns = this.table.getColumnCount();
        this.columnPreferredWidths = new int[nbrColumns];
        this.currentRow = 0;
        this.continueSizeCheck = true;
        this.checkRowBatch();
        if (this.continueSizeCheck && this.checkingThread == null) {
            this.checkingThread = new Thread((Runnable)this, "TableSizer");
            this.checkingThread.start();
        }
    }

    private int getPaddingForColumn(int col) {
        if (this.columnPaddings != null && col < this.columnPaddings.length) {
            return this.columnPaddings[col];
        }
        return this.defaultColumnPadding;
    }

    private void checkHeaderSize() {
        JTableHeader tableHeader = this.table.getTableHeader();
        TableColumnModel tcm = this.table.getColumnModel();
        int nbrColumns = this.table.getColumnCount();
        int cellInset = this.table.getRowMargin();
        for (int i = 0; i < nbrColumns; ++i) {
            TableColumn column = tcm.getColumn(i);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = tableHeader.getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, -1, i);
            int preferredWidth = comp.getPreferredSize().width + cellInset + this.getPaddingForColumn(i);
            if (this.columnPreferredWidths[i] >= preferredWidth) continue;
            this.totalPreferredWidth += preferredWidth - this.columnPreferredWidths[i];
            this.columnPreferredWidths[i] = preferredWidth;
        }
    }

    void checkRowBatch() {
        int nbrColumns = this.table.getColumnCount();
        int nbrRows = this.table.getRowCount();
        int previousTotal = this.totalPreferredWidth;
        int cellInset = this.table.getRowMargin() * 2;
        int endRow = this.currentRow + 100;
        if (endRow > nbrRows) {
            endRow = nbrRows;
        }
        if (this.currentRow < endRow) {
            if (this.currentRow == 0) {
                this.checkHeaderSize();
            }
            for (int i = this.currentRow; i < endRow; ++i) {
                for (int j = 0; j < nbrColumns; ++j) {
                    TableCellRenderer renderer = this.table.getCellRenderer(i, j);
                    Component comp = this.table.prepareRenderer(renderer, i, j);
                    int preferredWidth = comp.getPreferredSize().width + cellInset + this.getPaddingForColumn(j);
                    if (this.columnPreferredWidths[j] >= preferredWidth) continue;
                    this.totalPreferredWidth += preferredWidth - this.columnPreferredWidths[j];
                    this.columnPreferredWidths[j] = preferredWidth;
                }
            }
        }
        if (previousTotal != this.totalPreferredWidth) {
            this.resizeTableColumns();
        }
        this.currentRow = endRow;
        if (this.currentRow >= nbrRows) {
            this.continueSizeCheck = false;
            if (this.checkingThread != null) {
                this.checkingThread = null;
                throw new NullPointerException("Kill checking thread");
            }
        }
    }

    private void resizeTableColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        int nbrColumns = tcm.getColumnCount();
        for (int i = 0; i < nbrColumns; ++i) {
            TableColumn column = tcm.getColumn(i);
            column.setPreferredWidth(this.columnPreferredWidths[i]);
            column.setWidth(this.columnPreferredWidths[i]);
        }
        this.table.repaint();
    }

    public void run() {
        try {
            while (this.continueSizeCheck) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TableColumnSizer.this.checkRowBatch();
                    }
                });
            }
        }
        catch (InterruptedException ie) {
            log.error((Object)"Size checking thread interrupted", (Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            log.warn((Object)("End of size checking thread: " + Thread.currentThread() + " on exception"), (Throwable)ite);
        }
    }
}

