/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.sfac.gui.table.DragOutTableHeader;
import net.sf.sfac.gui.table.HidingTableColumnModel;
import net.sf.sfac.gui.table.SortModel;
import net.sf.sfac.setting.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortTable
extends JTable {
    private SortModel srtModel;
    private DragOutTableHeader tableHeader;
    private HidingTableColumnModel colModel;

    public SortTable() {
        this.init();
    }

    public SortTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public SortTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public SortTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public SortTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public SortTable(Vector<?> rowData, Vector<String> columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public SortTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    @Override
    public void setModel(TableModel newDataModel) {
        if (this.srtModel != null) {
            this.srtModel.setChainedModel(newDataModel);
        } else {
            super.setModel(newDataModel);
        }
    }

    private void init() {
        this.tableHeader = new DragOutTableHeader();
        this.setTableHeader(this.tableHeader);
        this.tableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SortTable.this.mouseClickedInHeader(e);
            }
        });
        this.colModel = new HidingTableColumnModel();
        this.setColumnModel(this.colModel);
    }

    public void useSettings(Settings settngs, String id) {
        TableModel tblModel;
        TableColumnModel colmnModel = this.getColumnModel();
        if (colmnModel instanceof HidingTableColumnModel) {
            ((HidingTableColumnModel)colmnModel).useSettings(settngs, id);
        }
        if ((tblModel = this.getModel()) instanceof SortModel) {
            ((SortModel)tblModel).useSettings(settngs, id);
        }
    }

    void mouseClickedInHeader(MouseEvent e) {
        JTableHeader tableHdr;
        int columnModelIndex;
        if (e.getClickCount() == 1 && (e.getModifiers() & 4) != 0 && (columnModelIndex = this.getColumnModelIndex(tableHdr = (JTableHeader)e.getSource(), e)) >= 0) {
            JPopupMenu popup = new JPopupMenu();
            if (this.srtModel != null) {
                this.srtModel.addDefaultPopupMenuItems(popup, tableHdr, e);
            }
            if (this.colModel != null) {
                this.colModel.addDefaultPopupMenuItems(popup, tableHdr);
            }
            popup.show(tableHdr, e.getX(), e.getY());
        }
    }

    private int getColumnModelIndex(JTableHeader tableHdr, MouseEvent e) {
        int columnModelIndex = -1;
        TableColumnModel theColumnModel = tableHdr.getColumnModel();
        int index = theColumnModel.getColumnIndexAtX(e.getX());
        if (index >= 0) {
            TableColumn column = theColumnModel.getColumn(index);
            columnModelIndex = column.getModelIndex();
        }
        return columnModelIndex;
    }

    public void installSorting() {
        if (this.srtModel != null) {
            throw new IllegalStateException("Sorting already installed");
        }
        this.srtModel = new SortModel(this.getModel());
        super.setModel(this.srtModel);
        this.srtModel.registerToTableColumns(this);
    }

    public SortModel getSortModel() {
        return this.srtModel;
    }

    public int getSelectedRowInRootModel() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= this.getRowCount()) {
            selectedRow = -1;
        }
        if (this.srtModel != null && selectedRow >= 0) {
            selectedRow = this.srtModel.getChainedModelRow(selectedRow);
        }
        return selectedRow;
    }

    public void setSelectedRowInRootModel(int chainedModelRow) {
        if (chainedModelRow >= 0 && chainedModelRow < this.getRowCount()) {
            int rowToSelect = chainedModelRow;
            if (this.srtModel != null) {
                rowToSelect = this.srtModel.getRow(chainedModelRow);
            }
            this.setRowSelectionInterval(rowToSelect, rowToSelect);
        } else {
            this.clearSelection();
        }
    }

    public int[] getSelectedRowsInRootModel() {
        int[] selectedRows = this.getSelectedRows();
        if (this.srtModel != null) {
            int len = selectedRows.length;
            for (int i = 0; i < len; ++i) {
                selectedRows[i] = this.srtModel.getChainedModelRow(selectedRows[i]);
            }
        }
        return selectedRows;
    }
}

