/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.sfac.gui.table.SortHeaderRenderer;
import net.sf.sfac.setting.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortModel
extends AbstractTableModel
implements TableModelListener {
    private static final String KEY_PREFIX = "ui.table.";
    private static final String SORT_POSTFIX = ".sort";
    public static final int NO_SORT = 0;
    public static final int SORT_NORMAL = 1;
    public static final int SORT_REVERSE = -1;
    private static final Comparator<Object> STRING_COMPARATOR = new StringComparator();
    private static final Comparator<Object> COMPARABLE_COMPARATOR = new ComparableComparator();
    private static final Comparator<Boolean> BOOLEAN_COMPARATOR = new BooleanComparator();
    private final Comparator<Integer> ROW_COMPARATOR = new RowComparator();
    TableModel chainedModel;
    private boolean sortingEnabled = true;
    Comparator<?>[] columnSorters;
    private int[] sortColumnIndexes;
    private List<Integer> modelIndexes = new ArrayList<Integer>();
    private int[] viewIndexes;
    private Map<Class<?>, Comparator<?>> defaultSorterMap;
    private List<JTableHeader> tableHeaders = new ArrayList<JTableHeader>();
    private MouseListener tableHeaderListener;
    private TableColumnModelListener columnModelListener;
    private Settings setts;
    private String sortSettingKey;

    public SortModel(TableModel chainedTableModel) {
        this.setChainedModel(chainedTableModel);
        this.buildListeners();
    }

    public void useSettings(Settings settngs, String id) {
        this.setts = settngs;
        if (this.setts != null) {
            this.sortSettingKey = KEY_PREFIX + id + SORT_POSTFIX;
            int[] sort = this.setts.getIntArrayProperty(this.sortSettingKey, null);
            if (sort != null) {
                this.setSortColumnIndexes(sort);
            }
        }
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setSortingEnabled(boolean enabled) {
        if (this.sortingEnabled != enabled) {
            this.sortingEnabled = enabled;
            this.sortConfigChanged();
        }
    }

    public Comparator<?> getSorterForColumn(int column) {
        return this.columnSorters[column];
    }

    public int getNumberOfSortedColumns() {
        return this.sortingEnabled ? this.getNbrSortColumn() : 0;
    }

    public boolean isColumnSorted(int column) {
        return this.sortingEnabled && this.isColumnSortedImpl(column);
    }

    public int getSortDirection(int column) {
        if (this.sortingEnabled) {
            int len = this.getNbrSortColumn();
            for (int i = 0; i < len; ++i) {
                if (this.getSortColumnAt(i) != column) continue;
                return this.getSortDirectionAt(i);
            }
        }
        return 0;
    }

    public int getSortIndex(int column) {
        if (this.sortingEnabled) {
            int len = this.getNbrSortColumn();
            for (int i = 0; i < len; ++i) {
                if (this.getSortColumnAt(i) != column) continue;
                return i;
            }
        }
        return -1;
    }

    public void setSortColumn(int column) {
        if (this.columnSorters[column] != null) {
            int nbrIndexes = this.getNbrSortColumn();
            if (nbrIndexes != 1) {
                this.sortColumnIndexes = new int[]{column};
            } else if (this.getSortColumnAt(0) == column) {
                this.invertSortColumnDirectionAt(0);
            } else {
                this.sortColumnIndexes[0] = column;
            }
            this.sortConfigChanged();
        }
    }

    public void addSortColumn(int column) {
        if (this.columnSorters[column] != null) {
            int nbrIndexes = this.getNbrSortColumn();
            if (nbrIndexes == 0) {
                this.sortColumnIndexes = new int[]{column};
            } else if (this.isColumnSortedImpl(column)) {
                for (int i = 0; i < nbrIndexes; ++i) {
                    if (this.getSortColumnAt(i) != column) continue;
                    this.invertSortColumnDirectionAt(i);
                    break;
                }
            } else {
                int[] newSortIndexes = new int[nbrIndexes + 1];
                System.arraycopy(this.sortColumnIndexes, 0, newSortIndexes, 0, nbrIndexes);
                newSortIndexes[nbrIndexes] = column;
                this.sortColumnIndexes = newSortIndexes;
            }
            this.sortConfigChanged();
        }
    }

    public void setSortColumnIndexes(int[] newIndexes) {
        this.sortColumnIndexes = newIndexes;
        this.sortConfigChanged();
    }

    public int[] getSortColumnIndexes() {
        return this.sortColumnIndexes == null ? null : (int[])this.sortColumnIndexes.clone();
    }

    public void removeSortColumn(int column) {
        int removedIndex = this.getSortIndex(column);
        if (this.sortingEnabled && removedIndex >= 0) {
            int nbrIndexes = this.getNbrSortColumn();
            if (nbrIndexes <= 1) {
                this.sortColumnIndexes = null;
            } else {
                int[] newSortIndexes = new int[nbrIndexes - 1];
                System.arraycopy(this.sortColumnIndexes, 0, newSortIndexes, 0, removedIndex);
                System.arraycopy(this.sortColumnIndexes, removedIndex + 1, newSortIndexes, removedIndex, nbrIndexes - removedIndex - 1);
                this.sortColumnIndexes = newSortIndexes;
            }
            this.sortConfigChanged();
        }
    }

    public void resetSorting() {
        int nbrIndexes = this.getNbrSortColumn();
        if (nbrIndexes > 0) {
            this.sortColumnIndexes = null;
            if (this.sortingEnabled) {
                this.sortConfigChanged();
            }
        }
    }

    public boolean isSorting() {
        return this.sortingEnabled ? this.getNbrSortColumn() > 0 : false;
    }

    public void setComparatorForColumn(Comparator<?> sorter, int column) {
        this.columnSorters[column] = sorter;
        this.resetSorting();
    }

    public void setDefaultComparatorForClass(Comparator<?> sorter, Class<?> cls) {
        if (this.defaultSorterMap == null) {
            this.defaultSorterMap = new HashMap(10);
        }
        this.defaultSorterMap.put(cls, sorter);
        int nbrCols = this.getColumnCount();
        for (int i = 0; i < nbrCols; ++i) {
            if (cls != this.getColumnClass(i)) continue;
            this.columnSorters[i] = sorter;
        }
        this.resetSorting();
    }

    public void registerToTableColumns(JTable table) {
        TableColumnModel cm = table.getColumnModel();
        cm.addColumnModelListener(this.columnModelListener);
        this.setTableColumnHeaderRenderers(cm, 0, cm.getColumnCount() - 1);
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.addMouseListener(this.tableHeaderListener);
        this.tableHeaders.add(tableHeader);
    }

    public void unregisterFormTableColumns(JTable table) {
        TableColumnModel cm = table.getColumnModel();
        cm.removeColumnModelListener(this.columnModelListener);
        int len = cm.getColumnCount();
        for (int i = 0; i < len; ++i) {
            TableCellRenderer headerRenderer;
            TableColumn col = cm.getColumn(i);
            if (col == null || !((headerRenderer = col.getHeaderRenderer()) instanceof SortHeaderRenderer)) continue;
            SortHeaderRenderer sorterRenderer = (SortHeaderRenderer)headerRenderer;
            sorterRenderer.setSortModel(null);
        }
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.removeMouseListener(this.tableHeaderListener);
        this.tableHeaders.remove(tableHeader);
    }

    int getNbrSortColumn() {
        return this.sortColumnIndexes == null ? 0 : this.sortColumnIndexes.length;
    }

    int getSortColumnAt(int index) {
        int column = this.sortColumnIndexes[index];
        if (column < 0) {
            column = -(column + 1);
        }
        return column;
    }

    int getSortDirectionAt(int index) {
        return this.sortColumnIndexes[index] < 0 ? -1 : 1;
    }

    private void invertSortColumnDirectionAt(int index) {
        int column = this.sortColumnIndexes[index];
        this.sortColumnIndexes[index] = -(column + 1);
    }

    private boolean isColumnSortedImpl(int col) {
        int nbrIndexes = this.getNbrSortColumn();
        for (int i = 0; i < nbrIndexes; ++i) {
            if (this.getSortColumnAt(i) != col) continue;
            return true;
        }
        return false;
    }

    private void sortConfigChanged() {
        this.sort();
        this.fireTableDataChanged();
        this.notifyTableHeaders();
        if (this.setts != null) {
            this.setts.setIntArrayProperty(this.sortSettingKey, this.getSortColumnIndexes());
        }
    }

    private Comparator<?> getComparatorForClass(Class<?> cls) {
        Comparator<Object> sorter = null;
        sorter = this.defaultSorterMap != null && this.defaultSorterMap.containsKey(cls) ? this.defaultSorterMap.get(cls) : (cls == String.class ? STRING_COMPARATOR : (cls == Boolean.class ? BOOLEAN_COMPARATOR : (Comparable.class.isAssignableFrom(cls) ? COMPARABLE_COMPARATOR : STRING_COMPARATOR)));
        return sorter;
    }

    private void initComparators() {
        int nbrCols = this.getColumnCount();
        this.columnSorters = new Comparator[nbrCols];
        for (int i = 0; i < nbrCols; ++i) {
            Class<?> columnClass = this.getColumnClass(i);
            this.columnSorters[i] = this.getComparatorForClass(columnClass);
        }
        this.sortColumnIndexes = null;
    }

    private void sort() {
        int nbrIndexes = this.getNbrSortColumn();
        this.checkArraySizes();
        if (this.sortingEnabled && nbrIndexes > 0) {
            Collections.sort(this.modelIndexes, this.ROW_COMPARATOR);
        } else {
            Collections.sort(this.modelIndexes);
        }
        int len = this.modelIndexes.size();
        for (int i = 0; i < len; ++i) {
            this.viewIndexes[this.getChainedModelRow((int)i)] = i;
        }
    }

    private void checkArraySizes() {
        block5: {
            int currentModelNbr;
            int nbrRows = this.chainedModel.getRowCount();
            if (this.viewIndexes == null || this.viewIndexes.length < nbrRows) {
                this.viewIndexes = new int[nbrRows + 10];
            }
            if (nbrRows == (currentModelNbr = this.modelIndexes.size())) break block5;
            if (currentModelNbr > nbrRows) {
                Collections.sort(this.modelIndexes);
                int nbrToRemove = currentModelNbr - nbrRows;
                for (int i = 1; i <= nbrToRemove; ++i) {
                    this.modelIndexes.remove(currentModelNbr - i);
                }
            } else {
                for (int i = currentModelNbr; i < nbrRows; ++i) {
                    this.modelIndexes.add(i);
                }
            }
        }
    }

    void setTableColumnHeaderRenderers(TableColumnModel cm, int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            TableColumn col = cm.getColumn(i);
            if (col == null) continue;
            int thisModelIndex = col.getModelIndex();
            TableCellRenderer headerRenderer = col.getHeaderRenderer();
            if (headerRenderer != null && headerRenderer instanceof SortHeaderRenderer) {
                SortHeaderRenderer sorterRenderer = (SortHeaderRenderer)headerRenderer;
                sorterRenderer.setSortModel(this);
                continue;
            }
            col.setHeaderRenderer(new SortHeaderRenderer(thisModelIndex < 0 ? null : this, thisModelIndex));
        }
    }

    private void notifyTableHeaders() {
        int len = this.tableHeaders.size();
        for (int i = 0; i < len; ++i) {
            JTableHeader header = this.tableHeaders.get(i);
            header.repaint();
        }
    }

    private void buildListeners() {
        this.tableHeaderListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SortModel.this.mouseClickedInHeader(e);
            }
        };
        this.columnModelListener = new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
                TableColumnModel cm = (TableColumnModel)e.getSource();
                SortModel.this.setTableColumnHeaderRenderers(cm, e.getFromIndex(), e.getToIndex());
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    void mouseClickedInHeader(MouseEvent e) {
        JTableHeader tableHeader;
        int columnModelIndex;
        if (e.getClickCount() == 1 && (e.getModifiers() & 0x10) != 0 && (columnModelIndex = this.getColumnModelIndex(tableHeader = (JTableHeader)e.getSource(), e)) >= 0) {
            boolean control;
            boolean shift = (e.getModifiers() & 1) != 0;
            boolean bl = control = (e.getModifiers() & 2) != 0;
            if (shift) {
                this.addSortColumn(columnModelIndex);
            } else if (control) {
                this.removeSortColumn(columnModelIndex);
            } else {
                this.setSortColumn(columnModelIndex);
            }
        }
    }

    private int getColumnModelIndex(JTableHeader tableHeader, MouseEvent e) {
        int columnModelIndex = -1;
        TableColumnModel columnModel = tableHeader.getColumnModel();
        int index = columnModel.getColumnIndexAtX(e.getX());
        if (index >= 0) {
            TableColumn column = columnModel.getColumn(index);
            columnModelIndex = column.getModelIndex();
        }
        return columnModelIndex;
    }

    public void addDefaultPopupMenuItems(JPopupMenu menu, JTableHeader tableHeader, MouseEvent mouseEvt) {
        if (this.isSortingEnabled()) {
            if (menu.getComponentCount() > 0) {
                menu.addSeparator();
            }
            final int columnModelIndex = this.getColumnModelIndex(tableHeader, mouseEvt);
            boolean columnSorted = this.isColumnSortedImpl(columnModelIndex);
            if (this.getNumberOfSortedColumns() != 1 || !columnSorted) {
                JMenuItem sortThis = new JMenuItem("Sort This Column");
                sortThis.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SortModel.this.setSortColumn(columnModelIndex);
                    }
                });
                menu.add(sortThis);
            }
            if (columnSorted) {
                JMenuItem invertOrder = new JMenuItem("Invert Sort Order");
                invertOrder.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SortModel.this.addSortColumn(columnModelIndex);
                    }
                });
                menu.add(invertOrder);
            } else if (this.getNumberOfSortedColumns() > 0) {
                JMenuItem addToSort = new JMenuItem("Add Column To Sort");
                addToSort.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SortModel.this.addSortColumn(columnModelIndex);
                    }
                });
                menu.add(addToSort);
            }
            if (this.getNumberOfSortedColumns() > 0) {
                JMenuItem clearSort = new JMenuItem("Clear Sort");
                clearSort.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SortModel.this.resetSorting();
                    }
                });
                menu.add(clearSort);
            }
        }
    }

    public void setChainedModel(TableModel chainedTableModel) {
        if (chainedTableModel == null) {
            throw new IllegalArgumentException("Chained table model cannot be null");
        }
        if (this.chainedModel != null) {
            this.chainedModel.removeTableModelListener(this);
        }
        this.chainedModel = chainedTableModel;
        this.chainedModel.addTableModelListener(this);
        this.initComparators();
        this.sort();
        this.fireTableStructureChanged();
    }

    public TableModel getChainedModel() {
        return this.chainedModel;
    }

    public int getChainedModelRow(int row) {
        return this.modelIndexes.get(row);
    }

    public int getRow(int chainedModelRow) {
        if (chainedModelRow >= this.modelIndexes.size()) {
            throw new ArrayIndexOutOfBoundsException("Sorted row index to high: " + chainedModelRow + " >= " + this.modelIndexes.size());
        }
        return this.viewIndexes[chainedModelRow];
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isSorting()) {
            switch (e.getType()) {
                case -1: {
                    this.tableRowsDeleted(e);
                    break;
                }
                case 1: {
                    this.tableRowsInserted(e);
                    break;
                }
                case 0: {
                    if (e.getFirstRow() == -1) {
                        this.tableStructureChanged(e);
                        break;
                    }
                    this.tableRowsUpdated(e);
                }
            }
        } else {
            if (e.getFirstRow() == -1) {
                this.initComparators();
            }
            this.sort();
            TableModelEvent newEvent = new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType());
            this.fireTableChanged(newEvent);
        }
    }

    private void tableRowsDeleted(TableModelEvent e) {
        int deletedRow = e.getFirstRow();
        if (deletedRow == e.getLastRow()) {
            int sortedDeletedRow = this.getRow(deletedRow);
            this.sort();
            this.fireTableRowsDeleted(sortedDeletedRow, sortedDeletedRow);
        } else {
            this.sort();
            this.fireTableDataChanged();
        }
    }

    private void tableRowsInserted(TableModelEvent e) {
        this.sort();
        int addedRow = e.getFirstRow();
        if (addedRow == e.getLastRow()) {
            int sortedAddedRow = this.getRow(addedRow);
            this.fireTableRowsInserted(sortedAddedRow, sortedAddedRow);
        } else {
            this.fireTableDataChanged();
        }
    }

    private void tableStructureChanged(TableModelEvent e) {
        this.initComparators();
        this.sort();
        this.fireTableStructureChanged();
    }

    private void tableRowsUpdated(TableModelEvent e) {
        int chainedRow = e.getFirstRow();
        if (chainedRow == e.getLastRow()) {
            int initialPlace = this.getRow(chainedRow);
            this.sort();
            int newPlace = this.getRow(chainedRow);
            if (initialPlace > newPlace) {
                int temp = initialPlace;
                initialPlace = newPlace;
                newPlace = temp;
            }
            this.fireTableRowsUpdated(initialPlace, newPlace);
        } else {
            this.sort();
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.chainedModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.chainedModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.chainedModel.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.chainedModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.chainedModel.isCellEditable(this.getChainedModelRow(rowIndex), columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.chainedModel.getValueAt(this.getChainedModelRow(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.chainedModel.setValueAt(aValue, this.getChainedModelRow(rowIndex), columnIndex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowComparator
    implements Comparator<Integer> {
        RowComparator() {
        }

        @Override
        public int compare(Integer obj1, Integer obj2) {
            int index1 = obj1;
            int index2 = obj2;
            int nbrIndexes = SortModel.this.getNbrSortColumn();
            for (int i = 0; i < nbrIndexes; ++i) {
                Object val2;
                Object val1;
                int column = SortModel.this.getSortColumnAt(i);
                int cmp = SortModel.this.columnSorters[column].compare(val1 = SortModel.this.chainedModel.getValueAt(index1, column), val2 = SortModel.this.chainedModel.getValueAt(index2, column));
                if (cmp == 0) continue;
                return SortModel.this.getSortDirectionAt(i) * cmp;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanComparator
    implements Comparator<Boolean> {
        BooleanComparator() {
        }

        @Override
        public int compare(Boolean obj1, Boolean obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            if (obj1.booleanValue()) {
                return obj2 != false ? 0 : -1;
            }
            return obj2 != false ? 1 : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComparableComparator
    implements Comparator<Object> {
        ComparableComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            if (obj1 instanceof Comparable) {
                return ((Comparable)obj1).compareTo(obj2);
            }
            return obj1.toString().compareTo(obj2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringComparator
    implements Comparator<Object> {
        private Collator collat = Collator.getInstance();

        StringComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return this.collat.compare(obj1.toString(), obj2.toString());
        }
    }
}

