/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import net.sf.sfac.gui.table.SortModel;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    private static Icon sortUpIcon;
    private static Icon sortDownIcon;
    private SortModel sortModel;
    private int columnIndex;
    private int charWidth;
    private Border defaultBorder;
    private Border borderForIcon;
    private Border borderForIconAndNumber;

    public SortHeaderRenderer() {
        if (sortUpIcon == null) {
            this.loadIcons();
        }
    }

    public SortHeaderRenderer(SortModel srtModel, int colIndex) {
        if (sortUpIcon == null) {
            this.loadIcons();
        }
        this.columnIndex = colIndex;
        this.setSortModel(srtModel);
    }

    public void setColumnIndex(int colIndex) {
        this.columnIndex = colIndex;
    }

    public void setSortModel(SortModel srtModel) {
        this.sortModel = srtModel;
        this.calculateBorder();
    }

    private void loadIcons() {
        try {
            sortUpIcon = new ImageIcon(this.getClass().getResource("up.png"));
            sortDownIcon = new ImageIcon(this.getClass().getResource("down.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calculateBorder() {
        this.defaultBorder = UIManager.getBorder("TableHeader.cellBorder");
        int leftInset = sortUpIcon.getIconWidth() + 4;
        Border emptyBorder = BorderFactory.createEmptyBorder(0, leftInset, 0, 0);
        this.borderForIcon = BorderFactory.createCompoundBorder(this.defaultBorder, emptyBorder);
        this.charWidth = this.getFontMetrics(this.getFont()).charWidth('9');
        emptyBorder = BorderFactory.createEmptyBorder(0, leftInset += this.charWidth, 0, 0);
        this.borderForIconAndNumber = BorderFactory.createCompoundBorder(this.defaultBorder, emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
        }
        this.setHorizontalAlignment(0);
        this.setText(value == null ? "" : value.toString());
        if (this.sortModel != null && this.sortModel.isColumnSorted(this.columnIndex)) {
            if (this.sortModel.getNumberOfSortedColumns() > 1) {
                this.setBorder(this.borderForIconAndNumber);
            } else {
                this.setBorder(this.borderForIcon);
            }
        } else {
            this.setBorder(this.defaultBorder);
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.sortModel != null && this.sortModel.isColumnSorted(this.columnIndex)) {
            Icon sortIcon = this.sortModel.getSortDirection(this.columnIndex) == 1 ? sortUpIcon : sortDownIcon;
            int x = 4;
            if (this.sortModel.getNumberOfSortedColumns() > 1) {
                String sortIndex = String.valueOf(this.sortModel.getSortIndex(this.columnIndex) + 1);
                int height = g.getFontMetrics().getHeight() - 2;
                g.drawString(sortIndex, x, height);
                x += this.charWidth + 1;
            }
            sortIcon.paintIcon(this, g, x, 1);
        }
    }
}

