/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HidingTableColumnModel
extends DefaultTableColumnModel {
    private static Log log = LogFactory.getLog(HidingTableColumnModel.class);
    private static final String KEY_PREFIX = "ui.table.";
    private static final String COLS_POSTFIX = ".columns";
    private static final String WIDTHS_POSTFIX = ".widths";
    private List<TableColumn> allColumns = new ArrayList<TableColumn>();
    private Settings setts;
    private String columnsSettingKey;
    private String widthsSettingKey;
    private PropertyChangeListener widthListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            HidingTableColumnModel.this.saveConfigSettings();
        }
    };
    JDialog hidingSelectionDialog;
    private JCheckBox[] hidingCheckBoxes;

    public void useSettings(Settings settngs, String id) {
        this.setts = settngs;
        if (this.setts != null) {
            int[] columnSizes;
            this.columnsSettingKey = KEY_PREFIX + id + COLS_POSTFIX;
            this.widthsSettingKey = KEY_PREFIX + id + WIDTHS_POSTFIX;
            int[] visibleColumns = this.setts.getIntArrayProperty(this.columnsSettingKey, null);
            if (visibleColumns != null) {
                this.setVisibleColumns(visibleColumns);
            }
            if ((columnSizes = this.setts.getIntArrayProperty(this.widthsSettingKey, null)) != null) {
                this.setColumnSizes(columnSizes);
            }
        }
    }

    void saveConfigSettings() {
        if (this.setts != null) {
            this.setts.setIntArrayProperty(this.columnsSettingKey, this.getVisibleColumns());
            this.setts.setIntArrayProperty(this.widthsSettingKey, this.getColumnSizes());
        }
    }

    public void showSelectionDialog(Component cmp) {
        JDialog dial = this.getSelectionDialog(cmp);
        this.refreshSelectionCheckBoxes();
        Point p = new Point(20, 20);
        SwingUtilities.convertPointToScreen(p, cmp);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        dial.setLocation(p);
        dial.setVisible(true);
    }

    public void addDefaultPopupMenuItems(JPopupMenu menu, final JTableHeader header) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        JMenuItem selectCols = new JMenuItem("Select Columns...");
        selectCols.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HidingTableColumnModel.this.showSelectionDialog(header);
            }
        });
        menu.add(selectCols);
    }

    private JDialog getSelectionDialog(Component cmp) {
        if (this.hidingSelectionDialog == null) {
            this.hidingSelectionDialog = new JDialog(JOptionPane.getFrameForComponent(cmp), "Column selection", true);
            int nbrCols = this.allColumns.size();
            JPanel checkBoxPanel = new JPanel(new GridLayout(nbrCols, 1));
            checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.hidingCheckBoxes = new JCheckBox[nbrCols];
            for (int i = 0; i < nbrCols; ++i) {
                TableColumn col = this.allColumns.get(i);
                Object header = col.getHeaderValue();
                this.hidingCheckBoxes[i] = new JCheckBox(header == null ? "" : header.toString());
                checkBoxPanel.add(this.hidingCheckBoxes[i]);
            }
            JPanel buttonPane = new JPanel();
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HidingTableColumnModel.this.commitAndClose();
                }
            });
            buttonPane.add(okButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HidingTableColumnModel.this.hidingSelectionDialog.setVisible(false);
                }
            });
            buttonPane.add(cancelButton);
            this.hidingSelectionDialog.getContentPane().add((Component)checkBoxPanel, "Center");
            this.hidingSelectionDialog.getContentPane().add((Component)buttonPane, "South");
            this.hidingSelectionDialog.pack();
        }
        return this.hidingSelectionDialog;
    }

    private void refreshSelectionCheckBoxes() {
        int nbrCols = this.allColumns.size();
        for (int i = 0; i < nbrCols; ++i) {
            TableColumn col = this.allColumns.get(i);
            this.hidingCheckBoxes[i].setSelected(this.tableColumns.contains(col));
        }
    }

    void commitAndClose() {
        int i;
        int len = this.hidingCheckBoxes.length;
        int nbrShown = 0;
        for (i = 0; i < len; ++i) {
            if (!this.hidingCheckBoxes[i].isSelected()) continue;
            ++nbrShown;
        }
        if (nbrShown == 0) {
            JOptionPane.showMessageDialog(this.hidingSelectionDialog, "You cannot hide all the columns", "Wrong selection", 0);
        } else {
            this.hidingSelectionDialog.setVisible(false);
            for (i = 0; i < len; ++i) {
                TableColumn col = this.allColumns.get(i);
                if (this.hidingCheckBoxes[i].isSelected()) {
                    this.showColumn(col);
                    continue;
                }
                this.hideColumn(col);
            }
        }
    }

    public TableColumn getBaseColumn(int columnModelIndex) {
        return this.allColumns.get(columnModelIndex);
    }

    public void showColumn(TableColumn aColumn) {
        if (!this.tableColumns.contains(aColumn)) {
            super.addColumn(aColumn);
            this.saveConfigSettings();
        }
    }

    public void hideColumn(TableColumn aColumn) {
        if (this.tableColumns.contains(aColumn)) {
            super.removeColumn(aColumn);
            this.saveConfigSettings();
        }
    }

    public void addColumn(TableColumn aColumn) {
        this.synchWithSuperclass();
        aColumn.removePropertyChangeListener(this.widthListener);
        aColumn.addPropertyChangeListener(this.widthListener);
        this.allColumns.add(aColumn);
        this.hidingSelectionDialog = null;
        super.addColumn(aColumn);
    }

    public void removeColumn(TableColumn column) {
        this.synchWithSuperclass();
        column.removePropertyChangeListener(this.widthListener);
        boolean removed = this.allColumns.remove(column);
        if (removed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove column " + column.getHeaderValue() + " = " + column.getModelIndex()));
            }
        } else {
            log.warn((Object)("Column not found " + column.getHeaderValue() + " = " + column.getModelIndex()));
        }
        this.hidingSelectionDialog = null;
        super.removeColumn(column);
    }

    private void synchWithSuperclass() {
        int superNbrCols;
        int totalNbrCols = this.allColumns.size();
        if (totalNbrCols != (superNbrCols = this.getColumnCount())) {
            this.allColumns.clear();
            for (int i = 0; i < superNbrCols; ++i) {
                this.allColumns.add(this.getColumn(i));
            }
        }
    }

    public int[] getVisibleColumns() {
        int nbrCols = this.getColumnCount();
        int[] cols = new int[nbrCols];
        for (int i = 0; i < nbrCols; ++i) {
            TableColumn col = this.getColumn(i);
            cols[i] = col.getModelIndex();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current visible table columns: : " + Arrays.toString(cols)));
        }
        return cols;
    }

    public int[] getColumnSizes() {
        int nbrCols = this.getColumnCount();
        int[] sizes = new int[nbrCols];
        for (int i = 0; i < nbrCols; ++i) {
            TableColumn col = this.getColumn(i);
            sizes[i] = col.getPreferredWidth();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current table columns sizes: " + Arrays.toString(sizes)));
        }
        return sizes;
    }

    public void setVisibleColumns(int[] cols) {
        int len = cols == null ? 0 : cols.length;
        int nbrCols = this.allColumns.size();
        if (len > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restore visible table columns: " + Arrays.toString(cols)));
            }
            while (this.getColumnCount() > 0) {
                super.removeColumn(this.getColumn(0));
            }
            for (int i = 0; i < len; ++i) {
                if (cols[i] >= nbrCols) continue;
                TableColumn col = this.allColumns.get(cols[i]);
                super.addColumn(col);
            }
        }
    }

    public void setColumnSizes(int[] sizes) {
        int len;
        int n = len = sizes == null ? 0 : sizes.length;
        if (len > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restore table columns sizes: " + Arrays.toString(sizes)));
            }
            if (len > this.getColumnCount()) {
                log.warn((Object)("Wrong number of saved column size: " + len + " instead of " + this.getColumnCount()));
                len = this.getColumnCount();
            }
            for (int i = 0; i < len; ++i) {
                TableColumn col = this.getColumn(i);
                col.setPreferredWidth(sizes[i]);
            }
        }
    }
}

