/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.table;

import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.sfac.gui.table.HidingTableColumnModel;

public class DragOutTableHeader
extends JTableHeader {
    private TableColumn draggedOut;

    public void setDraggedColumn(TableColumn aColumn) {
        super.setDraggedColumn(aColumn);
        if (this.draggedOut != null && aColumn == null) {
            TableColumnModel tcm;
            TableColumnModel cm = this.getColumnModel();
            if (cm.getColumnCount() > 1 && (tcm = this.getColumnModel()) instanceof HidingTableColumnModel) {
                HidingTableColumnModel htcm = (HidingTableColumnModel)tcm;
                htcm.hideColumn(this.draggedOut);
            }
            this.draggedOut = null;
        }
    }

    public void setDraggedDistance(int distance) {
        super.setDraggedDistance(distance);
        TableColumn dragged = this.getDraggedColumn();
        TableColumnModel cm = this.getColumnModel();
        if (dragged != null) {
            int draggedIndex = cm.getColumnIndex(dragged.getIdentifier());
            if (draggedIndex == 0 && -distance > dragged.getWidth()) {
                this.draggedOut = dragged;
            } else if (draggedIndex == cm.getColumnCount() - 1 && distance > dragged.getWidth()) {
                this.draggedOut = dragged;
            } else if (distance > 0) {
                this.draggedOut = null;
            }
        } else {
            this.draggedOut = null;
        }
    }
}

