/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.profiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.cmp.PartialLineBorder;
import net.sf.sfac.gui.editor.EditorOptionsDialog;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.BarChangeListener;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.profiles.ProfilesComboEditor;
import net.sf.sfac.setting.ProfilesClient;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SubSettingsList;
import net.sf.sfac.setting.SubSettingsProxy;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesController
implements BarChangeListener {
    private static Log log = LogFactory.getLog(ProfilesController.class);
    private ProfilesClient client;
    private SubSettingsList profiles;
    private JComboBox profilesCombo;
    private Action restoreProfile;
    private Action renameProfile;
    private Action removeProfile;

    public ProfilesController(ProfilesClient theClient, ActionRepository repo) {
        this.client = theClient;
        this.profiles = new SubSettingsList(this.client.getGlobalSettings(), "profiles");
        this.createActions(repo);
        repo.addBarChangeListener(this);
    }

    private void createActions(ActionRepository repo) {
        repo.addAction("storeProfile", "Store profile", "Store current profile", "Profile", "d/a1", "z1", SharedResources.getIcon("borderAdd.gif"), new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.storeCurrentSettings();
            }
        });
        this.restoreProfile = repo.addAction("restoreProfile", "Restore profile", "Restore profile values", "Profile", "d/a2", "z2", SharedResources.getIcon("refresh.gif"), new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.refreshProfile();
            }
        });
        this.renameProfile = repo.addAction("renameProfile", "Rename profile", "Rename current profile", "Profile", "d/a3", "z3", SharedResources.getIcon("rename.gif"), new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.renameProfile();
            }
        });
        this.removeProfile = repo.addAction("removeProfile", "Remove profile", "Remove current profile", "Profile", "d/a4", "z4", SharedResources.getIcon("borderRemove.gif"), new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.removeProfile();
            }
        });
        this.checkActionStates();
    }

    public SubSettingsList getProfiles() {
        return this.profiles;
    }

    void checkActionStates() {
        boolean oneProfileSelected = this.profiles.getSelectedItem() != null;
        this.restoreProfile.setEnabled(oneProfileSelected);
        this.renameProfile.setEnabled(oneProfileSelected);
        this.removeProfile.setEnabled(oneProfileSelected);
    }

    private String getSelectedProfileName() {
        SubSettingsProxy current = (SubSettingsProxy)this.profiles.getSelectedItem();
        return current == null ? null : current.getName();
    }

    private SubSettingsProxy getProfile(String profileName) {
        SubSettingsProxy subSett = null;
        int len = this.profiles.getSize();
        for (int i = 0; i < len; ++i) {
            subSett = (SubSettingsProxy)this.profiles.getSubSettingAt(i);
            if (!profileName.equals(subSett.getName())) continue;
            return subSett;
        }
        return null;
    }

    private void storeCurrentSettings(String profileName) {
        SubSettingsProxy subSet = this.getProfile(profileName);
        if (subSet == null) {
            log.info((Object)("Store new profile with name:" + profileName));
            subSet = (SubSettingsProxy)this.profiles.addSubSetting();
            subSet.setName(profileName);
            this.profiles.setSelectedItem((Object)subSet);
        } else {
            log.info((Object)("Update profile '" + profileName + "'"));
            subSet.clear();
            subSet.setName(profileName);
        }
        subSet.copyValues(this.client.getCurrentSubSettings());
    }

    private void restoreSelectedSettings() {
        SubSettingsProxy restored = (SubSettingsProxy)this.profiles.getSelectedItem();
        if (restored != null) {
            this.client.updateCurrentSubSettings((Settings)restored);
        } else {
            log.warn((Object)"No profile selected");
        }
    }

    private void changeSelectedProfileName(String oldName, String newName) {
        SubSettingsProxy selectedProfile = (SubSettingsProxy)this.profiles.getSelectedItem();
        selectedProfile.setName(newName);
        this.profiles.sort();
    }

    void storeCurrentSettings() {
        String name = null;
        try {
            EditorOptionsDialog dial = new EditorOptionsDialog(this.profilesCombo);
            dial.setTitle("Store Profile");
            StoreProfileParams params = new StoreProfileParams(this.getSelectedProfileName());
            Object result = dial.showAndEditObject(params);
            if ("OK".equals(result)) {
                name = params.getProfileName();
            }
            if (Comparison.isDefined(name)) {
                log.info((Object)("Store current profile with name='" + name + "'"));
                this.storeCurrentSettings(name);
                this.checkActionStates();
            } else {
                log.info((Object)"Store action cancelled by user");
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot store profile: " + name), (Throwable)e);
            ExceptionDialog.showExceptionDialog(this.profilesCombo, "Profile error", "Unable to add profile", e);
        }
    }

    void refreshProfile() {
        try {
            this.restoreSelectedSettings();
        }
        catch (Exception e) {
            String currentProfileName = this.getSelectedProfileName();
            log.error((Object)("Cannot add refresh pipeline with profile " + currentProfileName), (Throwable)e);
            ExceptionDialog.showExceptionDialog(this.profilesCombo, "Profile error", "Unable to use current profile: " + currentProfileName, e);
        }
    }

    void renameProfile() {
        String oldName = this.getSelectedProfileName();
        String newName = null;
        try {
            newName = JOptionPane.showInputDialog(this.profilesCombo, (Object)"New name for current profile");
            if (newName != null) {
                this.changeSelectedProfileName(oldName, newName);
            } else {
                log.info((Object)"Rename action cancelled by user");
            }
        }
        catch (Exception e) {
            log.error((Object)("The current profile (" + oldName + ") cannot be renamed to: " + newName), (Throwable)e);
            ExceptionDialog.showExceptionDialog(this.profilesCombo, "Profile error", "Unable to rename profile: " + oldName + " --> " + newName, e);
        }
    }

    void removeProfile() {
        String profileName = this.getSelectedProfileName();
        try {
            SubSettingsProxy selectedProfile = (SubSettingsProxy)this.profiles.getSelectedItem();
            if (selectedProfile != null) {
                this.profiles.removeSubSettings((Settings)selectedProfile);
                this.checkActionStates();
            }
        }
        catch (Exception e) {
            log.error((Object)("The current profile (" + profileName + ") cannot be removed"), (Throwable)e);
            ExceptionDialog.showExceptionDialog(this.profilesCombo, "Profile error", "Unable to remove profile: " + profileName, e);
        }
    }

    public void beforeMnemonicAssignment(ActionRepository repo) {
    }

    public void menubarCreated(ActionRepository repo, JMenuBar menubar) {
    }

    public void toolbarCreated(ActionRepository repo, JToolBar toolbar) {
        int insertIndex = toolbar.getComponentCount() - 4;
        toolbar.setBorder(new PartialLineBorder(new Color(153, 153, 153), 2, 2));
        toolbar.add((Component)new JLabel("Current Profile:"), insertIndex);
        toolbar.add(Box.createHorizontalStrut(4), insertIndex + 1);
        this.profilesCombo = new JComboBox(this.profiles);
        Dimension preferred = this.profilesCombo.getPreferredSize();
        System.out.println("preffered = " + preferred);
        this.profilesCombo.setMaximumSize(preferred);
        this.profilesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProfilesController.this.checkActionStates();
                    ProfilesController.this.refreshProfile();
                }
            }
        });
        toolbar.add((Component)this.profilesCombo, insertIndex + 2);
        toolbar.add(Box.createHorizontalGlue());
    }

    @EditorConfig(label="")
    public class StoreProfileParams {
        private StoreAction action;
        private String existingProfileName;
        private String newProfileName;

        public StoreProfileParams(String currentProfileName) {
            if (currentProfileName != null) {
                this.action = StoreAction.OVERRIDE;
                this.existingProfileName = currentProfileName;
            } else {
                this.action = StoreAction.ADD_NEW;
            }
        }

        public String getProfileName() {
            return this.action == StoreAction.OVERRIDE ? this.existingProfileName : this.newProfileName;
        }

        @EditorConfig(label="Action", index=0, editor="net.sf.sfac.gui.profiles.ProfileNameVisibilityEditor")
        public StoreAction getAction() {
            return this.action;
        }

        public void setAction(StoreAction act) {
            this.action = act;
        }

        @EditorConfig(label="Profile Name", editor="net.sf.sfac.gui.profiles.ProfilesComboEditor")
        public String getExistingProfileName() {
            ProfilesComboEditor.class.getName();
            return this.existingProfileName;
        }

        public void setExistingProfileName(String profileName) {
            this.existingProfileName = profileName;
        }

        @EditorConfig(label="New Profile Name")
        public String getNewProfileName() {
            return this.newProfileName;
        }

        public void setNewProfileName(String profileName) {
            this.newProfileName = profileName;
        }

        public SubSettingsList getProfileList() {
            return ProfilesController.this.getProfiles();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreAction {
        OVERRIDE("Override existing profile"),
        ADD_NEW("Add new profile");

        private String text;

        private StoreAction(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }
}

