/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

class SparseMatrix {
    private Object[][] matrix = new Object[5][0];
    private int nbrRows = 0;
    private int[] nbrCols = new int[5];
    private int nbrMaxCol = 0;

    protected SparseMatrix() {
    }

    protected Object get(int gridX, int gridY) {
        if (gridY < this.nbrRows && gridX < this.nbrCols[gridY]) {
            return this.matrix[gridY][gridX];
        }
        return null;
    }

    protected void set(int gridX, int gridY, Object element) {
        if (element == null) {
            this.removeEl(gridX, gridY);
        } else {
            this.addEl(gridX, gridY, element);
        }
    }

    private void addEl(int gridX, int gridY, Object element) {
        Object[] rowArray;
        int rowLen;
        int len = this.matrix.length;
        if (gridY >= len) {
            int newLen = len * 2;
            if (gridX >= newLen) {
                newLen = gridX + 5;
            }
            Object[][] newMatrix = new Object[newLen][0];
            System.arraycopy(this.matrix, 0, newMatrix, 0, len);
            this.matrix = newMatrix;
            int[] newNbrCols = new int[newLen];
            System.arraycopy(this.nbrCols, 0, newNbrCols, 0, len);
            this.nbrCols = newNbrCols;
        }
        if (gridX >= (rowLen = (rowArray = this.matrix[gridY]).length)) {
            int newLen = rowLen * 2;
            if (gridX >= newLen) {
                newLen = gridX + 5;
            }
            Object[] newRowArray = new Object[newLen];
            System.arraycopy(rowArray, 0, newRowArray, 0, rowLen);
            rowArray = newRowArray;
            this.matrix[gridY] = newRowArray;
        }
        rowArray[gridX] = element;
        if (gridY >= this.nbrRows) {
            this.nbrRows = gridY + 1;
        }
        if (gridX >= this.nbrCols[gridY]) {
            this.nbrCols[gridY] = gridX + 1;
        }
        if (gridX >= this.nbrMaxCol) {
            this.nbrMaxCol = gridX + 1;
        }
    }

    private void removeEl(int gridX, int gridY) {
        if (gridY < this.nbrRows && gridX < this.nbrCols[gridY]) {
            boolean theMaxRow = this.nbrMaxCol == this.nbrCols[gridY];
            Object[] rowArray = this.matrix[gridY];
            rowArray[gridX] = null;
            while (this.nbrCols[gridY] > 0 && rowArray[this.nbrCols[gridY] - 1] == null) {
                int n = gridY;
                this.nbrCols[n] = this.nbrCols[n] - 1;
            }
            if (this.nbrCols[gridY] == 0) {
                while (this.nbrRows > 0 && this.nbrCols[this.nbrRows - 1] == 0) {
                    --this.nbrRows;
                }
            }
            if (theMaxRow && this.nbrMaxCol != this.nbrCols[gridY]) {
                this.nbrMaxCol = 0;
                for (int i = 0; i < this.nbrRows; ++i) {
                    if (this.nbrMaxCol >= this.nbrCols[i]) continue;
                    this.nbrMaxCol = this.nbrCols[i];
                }
            }
        }
    }

    protected int getNbrRows() {
        return this.nbrRows;
    }

    protected int getNbrColumns(int gridY) {
        return gridY < this.nbrRows ? this.nbrCols[gridY] : 0;
    }

    protected int getMaxNbrColumns() {
        return this.nbrMaxCol;
    }

    protected int getMinRow() {
        for (int i = 0; i < this.nbrRows; ++i) {
            if (this.nbrCols[i] <= 0) continue;
            return i;
        }
        return -1;
    }
}

