/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.sf.sfac.gui.layout.CellInfo;
import net.sf.sfac.gui.layout.LineInfo;
import net.sf.sfac.gui.layout.MultiBorder;
import net.sf.sfac.gui.layout.MultiBorderConstraints;
import net.sf.sfac.gui.layout.SparseMatrix;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MultiBorderLayout
implements LayoutManager2 {
    private static Log log = LogFactory.getLog(MultiBorderLayout.class);
    private static boolean debugMode = false;
    private boolean cacheValid = false;
    private SparseMatrix cells;
    private List<MultiBorder> bordersList;
    private int borderFlag;
    private int width;
    private int height;
    private LineInfo[] colInfos;
    private LineInfo[] rowInfos;
    private double weightX;
    private double weightY;
    private int layoutAlignment;
    private MultiBorderConstraints currentPosition;
    private JComponent layoutContainer;
    private Insets globalInsets = new Insets(0, 0, 0, 0);

    public MultiBorderLayout() {
        this.cells = new SparseMatrix();
        this.bordersList = new ArrayList<MultiBorder>();
        this.currentPosition = new MultiBorderConstraints();
        this.currentPosition.initCurrentPosition();
        this.layoutAlignment = 10;
        this.colInfos = new LineInfo[5];
        this.rowInfos = new LineInfo[5];
        for (int i = 0; i < 5; ++i) {
            this.colInfos[i] = new LineInfo();
            this.rowInfos[i] = new LineInfo();
        }
    }

    public static boolean getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean newDebugMode) {
        debugMode = newDebugMode;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.cells.getMaxNbrColumns() + "x" + this.cells.getNbrRows() + " cells, align=" + this.layoutAlignment + "]";
    }

    public void setLayoutAlignment(int alignment) {
        this.layoutAlignment = alignment;
    }

    public int getLayoutAlignment() {
        return this.layoutAlignment;
    }

    public Insets getGlobalInsets() {
        return this.globalInsets;
    }

    public void setGlobalInsets(Insets newGlobalInsets) {
        this.globalInsets = newGlobalInsets;
        if (this.globalInsets == null) {
            this.globalInsets = new Insets(0, 0, 0, 0);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("MultiBorderLayout requires a MultiBorderConstraints to add a component");
    }

    public void removeLayoutComponent(Component comp) {
        this.invalidateCache();
        this.currentPosition.initCurrentPosition();
        int nbrRow = this.cells.getNbrRows();
        for (int y = 0; y < nbrRow; ++y) {
            int nbrX = this.cells.getNbrColumns(y);
            for (int x = 0; x < nbrX; ++x) {
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                if (cell == null || !cell.removeLayoutComponent(comp)) continue;
                if (cell.isEmpty()) {
                    int cellEndX = cell.getGridX() + cell.getGridWith();
                    int cellEndY = cell.getGridY() + cell.getGridHeight();
                    for (int i = cell.getGridX(); i < cellEndX; ++i) {
                        for (int j = cell.getGridY(); j < cellEndY; ++j) {
                            this.cells.set(i, j, null);
                        }
                    }
                    this.checkBordersForRemove(cell);
                }
                return;
            }
        }
        log.warn((Object)("The component [" + comp + "] to remove is not in this layoutManager"));
    }

    private void checkBordersForRemove(CellInfo removedCell) {
        int len = this.bordersList.size();
        for (int i = 0; i < len; ++i) {
            MultiBorder border = this.bordersList.get(i);
            if (!border.containsCell(removedCell) || !border.isEmpty()) continue;
            this.removeBorder(border);
        }
    }

    private void removeBorder(MultiBorder border) {
        this.bordersList.remove(border);
        border.dispose(this.layoutContainer);
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        this.validateCache(container);
        return new Dimension(this.width, this.height);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        this.validateCache(container);
        return new Dimension(this.width, this.height);
    }

    public void layoutContainer(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        this.validateCache(container);
        this.layout(container);
        this.layoutBorders(container);
    }

    public void addLayoutComponent(Component comp, Object constr) {
        if (constr instanceof MultiBorder) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added extra component: " + comp.getClass()));
            }
            return;
        }
        if (constr instanceof MultiBorderConstraints) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added layout component: " + comp.getClass()));
            }
            this.currentPosition.updateCurrentPosition(this, (MultiBorderConstraints)constr);
            CellInfo info = (CellInfo)this.cells.get(this.currentPosition.gridx, this.currentPosition.gridy);
            if (info == null) {
                int lastY;
                info = new CellInfo(this.currentPosition);
                int lastX = this.currentPosition.gridx + this.currentPosition.gridwidth - 1;
                for (int y = lastY = this.currentPosition.gridy + this.currentPosition.gridheight - 1; y >= this.currentPosition.gridy; --y) {
                    for (int x = lastX; x >= this.currentPosition.gridx; --x) {
                        this.cells.set(x, y, info);
                    }
                }
            }
            info.addComponent(comp, this.currentPosition);
            MultiBorder lastBorder = null;
            if (this.borderFlag != this.currentPosition.getBorderFlag()) {
                Iterator<MultiBorder> it = this.currentPosition.getBordersIterator();
                while (it.hasNext()) {
                    MultiBorder border = it.next();
                    if (!this.bordersList.contains(border)) {
                        this.bordersList.add(border);
                        border.setLayout(this);
                        if (this.layoutContainer != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("addLayoutComponent Call addComponents on border: " + border));
                            }
                            border.addExtraComponents(this.layoutContainer);
                        }
                    }
                    if (lastBorder != null) {
                        lastBorder.setNestedBorder(border);
                    }
                    lastBorder = border;
                }
                this.borderFlag = this.currentPosition.getBorderFlag();
                if (this.borderFlag < 0) {
                    this.borderFlag = 0;
                }
            }
        } else {
            throw new IllegalArgumentException("MultiBorderLayout requires a MultiBorderConstraints to add a component");
        }
        this.invalidateCache();
    }

    public Dimension maximumLayoutSize(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        if (container != this.layoutContainer) {
            this.setLayoutContainer(container);
        }
        this.invalidateCache();
    }

    int getNbrRow(int gridx) {
        int nbrRow;
        if (gridx >= 0) {
            if (gridx >= this.cells.getMaxNbrColumns()) {
                return 0;
            }
            for (nbrRow = this.cells.getNbrRows(); nbrRow > 0 && this.cells.get(gridx, nbrRow - 1) == null; --nbrRow) {
            }
        }
        return nbrRow;
    }

    int getNbrColumn(int gridy) {
        return this.cells.getNbrColumns(gridy);
    }

    CellInfo getCellInfo(int gridx, int gridy) {
        return (CellInfo)this.cells.get(gridx, gridy);
    }

    LineInfo getColumnInfo(int gridx) {
        return this.colInfos[gridx];
    }

    LineInfo getRowInfo(int gridy) {
        return this.rowInfos[gridy];
    }

    private void invalidateCache() {
        this.cacheValid = false;
    }

    private void validateCache(Container cont) {
        if (!this.cacheValid) {
            this.width = 0;
            this.height = 0;
            this.resetBorder();
            this.calculateBorders(cont);
            this.resetRowColInfo();
            this.calculateSize();
            this.cacheValid = true;
        }
    }

    private void resetBorder() {
        int nbrY = this.cells.getNbrRows();
        for (int y = 0; y < nbrY; ++y) {
            int nbrX = this.cells.getNbrColumns(y);
            for (int x = 0; x < nbrX; ++x) {
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                if (cell == null || !cell.beginAt(x, y)) continue;
                cell.resetBorder();
            }
        }
    }

    private void calculateBorders(Container cont) {
        int len = this.bordersList.size();
        for (int i = 0; i < len; ++i) {
            MultiBorder border = this.bordersList.get(i);
            border.adaptCellSizes(cont);
        }
    }

    private void resetRowColInfo() {
        int nbrColInfo = this.colInfos.length;
        int nbrCol = this.cells.getMaxNbrColumns();
        if (nbrCol > nbrColInfo) {
            for (int i = 0; i < nbrColInfo; ++i) {
                this.colInfos[i].reset();
            }
            LineInfo[] newColInfos = new LineInfo[nbrCol];
            System.arraycopy(this.colInfos, 0, newColInfos, 0, nbrColInfo);
            for (int i = nbrColInfo; i < nbrCol; ++i) {
                newColInfos[i] = new LineInfo();
            }
            this.colInfos = newColInfos;
        } else {
            for (int i = 0; i < nbrCol; ++i) {
                this.colInfos[i].reset();
            }
        }
        int nbrRowInfo = this.rowInfos.length;
        int nbrRow = this.cells.getNbrRows();
        if (nbrRow > nbrRowInfo) {
            for (int i = 0; i < nbrRowInfo; ++i) {
                this.rowInfos[i].reset();
            }
            LineInfo[] newRowInfos = new LineInfo[nbrRow];
            System.arraycopy(this.rowInfos, 0, newRowInfos, 0, nbrRowInfo);
            for (int i = nbrRowInfo; i < nbrRow; ++i) {
                newRowInfos[i] = new LineInfo();
            }
            this.rowInfos = newRowInfos;
        } else {
            for (int i = 0; i < nbrRow; ++i) {
                this.rowInfos[i].reset();
            }
        }
    }

    private void calculateSize() {
        int i;
        int nbrX;
        int y;
        int nbrCol = this.cells.getMaxNbrColumns();
        int nbrRow = this.cells.getNbrRows();
        for (y = 0; y < nbrRow; ++y) {
            nbrX = this.cells.getNbrColumns(y);
            LineInfo rowInfo = this.rowInfos[y];
            for (int x = 0; x < nbrX; ++x) {
                double weightY1;
                double weightX1;
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                LineInfo colInfo = this.colInfos[x];
                if (cell == null) continue;
                if (cell.beginAt(x, y)) {
                    cell.calculateSize();
                    if (cell.getGridWith() == 1 && colInfo.space < cell.getWidth()) {
                        colInfo.space = cell.getWidth();
                    }
                    if (cell.getGridHeight() == 1 && rowInfo.space < cell.getHeight()) {
                        rowInfo.space = cell.getHeight();
                    }
                    if (colInfo.beforeSpace < cell.getLeftBorderSpace()) {
                        colInfo.beforeSpace = cell.getLeftBorderSpace();
                    }
                    if (rowInfo.beforeSpace < cell.getTopBorderSpace()) {
                        rowInfo.beforeSpace = cell.getTopBorderSpace();
                    }
                }
                if (colInfo.weight < (weightX1 = cell.getWeightX() / (double)cell.getGridWith())) {
                    colInfo.weight = weightX1;
                }
                if (rowInfo.weight < (weightY1 = cell.getWeightY() / (double)cell.getGridHeight())) {
                    rowInfo.weight = weightY1;
                }
                if (!cell.endAt(x, y)) continue;
                if (colInfo.afterSpace < cell.getRightBorderSpace()) {
                    colInfo.afterSpace = cell.getRightBorderSpace();
                }
                if (rowInfo.afterSpace >= cell.getBottomBorderSpace()) continue;
                rowInfo.afterSpace = cell.getBottomBorderSpace();
            }
        }
        for (y = 0; y < nbrRow; ++y) {
            nbrX = this.cells.getNbrColumns(y);
            for (int x = 0; x < nbrX; ++x) {
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                if (cell == null || !cell.beginAt(x, y)) continue;
                cell.balanceExtraSize(this.colInfos, this.rowInfos);
            }
        }
        this.width = 0;
        this.height = 0;
        this.weightX = 0.0;
        this.weightY = 0.0;
        for (i = 0; i < nbrCol; ++i) {
            LineInfo colInfo = this.colInfos[i];
            this.width += colInfo.getTotalSpace();
            this.weightX += colInfo.weight;
        }
        for (i = 0; i < nbrRow; ++i) {
            LineInfo rowInfo = this.rowInfos[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + i + " height = " + rowInfo.beforeSpace + " - " + rowInfo.space + " - " + rowInfo.afterSpace));
            }
            this.height += rowInfo.getTotalSpace();
            this.weightY += rowInfo.weight;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MultiBorderLayout sized: " + this.width + "x" + this.height));
        }
    }

    public void layout(Container container) {
        int y;
        int posY;
        int posX;
        int remainderX = container.getWidth() - this.width - this.globalInsets.left - this.globalInsets.right;
        int weightedRemainderX = (int)((double)remainderX * (1.0 - this.weightX));
        int remainderY = container.getHeight() - this.height - this.globalInsets.top - this.globalInsets.bottom;
        int weightedRemainderY = (int)((double)remainderY * (1.0 - this.weightY));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Layout from " + this.width + "x" + this.height + " to " + container.getWidth() + "x" + container.getHeight() + " (reminder " + remainderX + "x" + remainderY + ")"));
        }
        int nbrY = this.cells.getNbrRows();
        int nbrMaxX = this.cells.getMaxNbrColumns();
        switch (this.layoutAlignment) {
            case 10: {
                posX = this.globalInsets.left + weightedRemainderX / 2;
                posY = this.globalInsets.top + weightedRemainderY / 2;
                break;
            }
            case 11: {
                posX = this.globalInsets.left + weightedRemainderX / 2;
                posY = this.globalInsets.top;
                break;
            }
            case 12: {
                posX = this.globalInsets.left + weightedRemainderX;
                posY = this.globalInsets.top;
                break;
            }
            case 13: {
                posX = this.globalInsets.left + weightedRemainderX;
                posY = this.globalInsets.top + weightedRemainderY / 2;
                break;
            }
            case 14: {
                posX = this.globalInsets.left + weightedRemainderX;
                posY = this.globalInsets.top + weightedRemainderY;
                break;
            }
            case 15: {
                posX = this.globalInsets.left + weightedRemainderX / 2;
                posY = this.globalInsets.top + weightedRemainderY;
                break;
            }
            case 16: {
                posX = this.globalInsets.left;
                posY = this.globalInsets.top + weightedRemainderY;
                break;
            }
            case 17: {
                posX = this.globalInsets.left;
                posY = this.globalInsets.top + weightedRemainderY / 2;
                break;
            }
            default: {
                posX = this.globalInsets.left;
                posY = this.globalInsets.top;
            }
        }
        for (int x = 0; x < nbrMaxX; ++x) {
            this.colInfos[x].weightedSpace = this.colInfos[x].weight > 0.0 && remainderX > 0 ? (this.colInfos[x].weight > 1.0 ? this.colInfos[x].space + (int)((double)remainderX * (this.colInfos[x].weight / this.weightX)) : this.colInfos[x].space + (int)((double)remainderX * this.colInfos[x].weight)) : this.colInfos[x].space;
            if (log.isTraceEnabled()) {
                log.trace((Object)("  * Col " + x + ": weighted at " + this.colInfos[x].weight + " from " + this.colInfos[x].space + " to " + this.colInfos[x].weightedSpace));
            }
            this.colInfos[x].pos = posX;
            posX += this.colInfos[x].getLayedTotalSpace();
        }
        for (y = 0; y < nbrY; ++y) {
            this.rowInfos[y].weightedSpace = this.rowInfos[y].weight > 0.0 && remainderY > 0 ? (this.rowInfos[y].weight > 1.0 ? this.rowInfos[y].space + (int)((double)remainderY * (this.rowInfos[y].weight / this.weightY)) : this.rowInfos[y].space + (int)((double)remainderY * this.rowInfos[y].weight)) : this.rowInfos[y].space;
            if (log.isTraceEnabled()) {
                log.trace((Object)("  * Row " + y + ": weighted at " + this.rowInfos[y].weight + " from " + this.rowInfos[y].space + " to " + this.rowInfos[y].weightedSpace));
            }
            this.rowInfos[y].pos = posY;
            posY += this.rowInfos[y].getLayedTotalSpace();
        }
        for (y = 0; y < nbrY; ++y) {
            int nbrX = this.cells.getNbrColumns(y);
            for (int x = 0; x < nbrX; ++x) {
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                if (cell == null || !cell.beginAt(x, y)) continue;
                cell.layout(this.colInfos, this.rowInfos);
            }
        }
    }

    private void layoutBorders(Container container) {
        int len = this.bordersList.size();
        for (int i = 0; i < len; ++i) {
            MultiBorder border = this.bordersList.get(i);
            border.layout(container);
        }
    }

    private void setLayoutContainer(Component cmp) {
        try {
            if (this.layoutContainer != null) {
                throw new IllegalArgumentException("MultiBorderLayout can only be layout of one container");
            }
            this.layoutContainer = (JComponent)cmp;
            this.layoutContainer.setBorder(new BorderAdapter());
            this.layoutContainer.addPropertyChangeListener("border", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    throw new IllegalArgumentException("You cannot change the border set by MultiBorderLayout");
                }
            });
            int len = this.bordersList.size();
            for (int i = 0; i < len; ++i) {
                MultiBorder border = this.bordersList.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setLayoutContainer Call addComponents on border: " + border));
                }
                border.addExtraComponents(this.layoutContainer);
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("MultiBorderLayout can only be used on JComponents");
        }
    }

    void paintBorders(Component cmp, Graphics g) {
        int len = this.bordersList.size();
        for (int i = 0; i < len; ++i) {
            MultiBorder border = this.bordersList.get(i);
            border.paint(cmp, g);
        }
        if (debugMode) {
            this.painCells(cmp, g);
        }
    }

    private void painCells(Component cmp, Graphics g) {
        int nbrY = this.cells.getNbrRows();
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setColor(Color.RED);
        g.setFont(new Font("Dialog", 0, 8));
        for (int y = 0; y < nbrY; ++y) {
            int nbrX = this.cells.getNbrColumns(y);
            for (int x = 0; x < nbrX; ++x) {
                CellInfo cell = (CellInfo)this.cells.get(x, y);
                if (cell == null || !cell.beginAt(x, y) || cell.isCollapsed()) continue;
                int posX = this.colInfos[x].getLayedStart();
                int posY = this.rowInfos[y].getLayedStart();
                int drawWidth = this.getUsedSpace(this.colInfos, x, x + cell.getGridWith() - 1);
                int drawHeight = this.getUsedSpace(this.rowInfos, y, y + cell.getGridHeight() - 1);
                g.drawRect(posX, posY, drawWidth, drawHeight);
                if (drawWidth <= 12 || drawHeight <= 10) continue;
                String cellPos = "" + cell.getGridX() + "-" + cell.getGridY();
                g.drawString(cellPos, posX + 2, posY + 10);
            }
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    private int getUsedSpace(LineInfo[] infos, int from, int to) {
        int space = 0;
        for (int i = from; i <= to; ++i) {
            if (i != from) {
                space += infos[i].beforeSpace;
            }
            space += infos[i].weightedSpace;
            if (i == to) continue;
            space += infos[i].afterSpace;
        }
        return space;
    }

    class BorderAdapter
    implements Border {
        BorderAdapter() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width1, int height1) {
            MultiBorderLayout.this.paintBorders(c, g);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(10, 10, 10, 10);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

