/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.sfac.gui.layout.MultiBorder;
import net.sf.sfac.gui.layout.MultiBorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBorderConstraints
implements Cloneable {
    public static final int NEXT = -1;
    public static final int CURRENT = -1000;
    public static final int NEW = -1001;
    public static final int NEXT_IF_COLLISION = -1002;
    public static final int UNDEFINED = -1003;
    public static final int NONE = 0;
    public static final int BOTH = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int CENTER = 10;
    public static final int NORTH = 11;
    public static final int NORTHEAST = 12;
    public static final int EAST = 13;
    public static final int SOUTHEAST = 14;
    public static final int SOUTH = 15;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 17;
    public static final int NORTHWEST = 18;
    public int gridx;
    public int gridy;
    public int gridwidth;
    public int gridheight;
    public double weightx;
    public double weighty;
    public int anchor;
    public int fill;
    public Insets insets;
    private List<MultiBorder> borders;
    private int borderFlag;

    public MultiBorderConstraints() {
        this.gridx = -1;
        this.gridy = -1000;
        this.gridwidth = 1;
        this.gridheight = 1;
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.anchor = 17;
        this.fill = 0;
        this.insets = null;
    }

    public MultiBorderConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight, double newWeightX, double newWeightY, int newAnchor, int newFill, Insets newInsets) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        this.weightx = newWeightX;
        this.weighty = newWeightY;
        this.anchor = newAnchor;
        this.fill = newFill;
        this.insets = newInsets;
    }

    public MultiBorderConstraints(MultiBorderConstraints other) {
        this.gridx = other.gridx;
        this.gridy = other.gridy;
        this.gridwidth = other.gridwidth;
        this.gridheight = other.gridheight;
        this.weightx = other.weightx;
        this.weighty = other.weighty;
        this.anchor = other.anchor;
        this.fill = other.fill;
        this.insets = other.insets == null ? null : new Insets(other.insets.top, other.insets.left, other.insets.bottom, other.insets.right);
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight, double newWeightX, double newWeightY, int newAnchor, int newFill, Insets newInsets) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        this.weightx = newWeightX;
        this.weighty = newWeightY;
        this.anchor = newAnchor;
        this.fill = newFill;
        this.insets = newInsets;
        return this;
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight, double newWeightX, double newWeightY, int newAnchor, int newFill) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        this.weightx = newWeightX;
        this.weighty = newWeightY;
        this.anchor = newAnchor;
        this.fill = newFill;
        return this;
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight, double newWeightX, double newWeightY, int newAnchor) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        this.weightx = newWeightX;
        this.weighty = newWeightY;
        this.anchor = newAnchor;
        return this;
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight, double newWeightX, double newWeightY) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        this.weightx = newWeightX;
        this.weighty = newWeightY;
        return this;
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY, int newGridWidth, int newGridHeight) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        this.gridwidth = newGridWidth;
        this.gridheight = newGridHeight;
        return this;
    }

    public MultiBorderConstraints setConstraints(int newGridX, int newGridY) {
        this.gridx = newGridX;
        this.gridy = newGridY;
        return this;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        if (this.insets == null) {
            this.insets = new Insets(top, left, bottom, right);
        } else {
            this.insets.top = top;
            this.insets.left = left;
            this.insets.bottom = bottom;
            this.insets.right = right;
        }
    }

    public void addBorder(MultiBorder brdr) {
        if (this.borders == null) {
            this.borders = new ArrayList<MultiBorder>();
        }
        this.borders.add(brdr);
        ++this.borderFlag;
    }

    public void removeBorder(MultiBorder brdr) {
        if (this.borders != null) {
            this.borders.remove(brdr);
        }
    }

    public void removeAllBorders() {
        if (this.borders != null) {
            this.borders.clear();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("Should not happen");
        }
    }

    protected Iterator<MultiBorder> getBordersIterator() {
        if (this.borders == null) {
            this.borders = new ArrayList<MultiBorder>();
        }
        return this.borders.iterator();
    }

    protected int getBorderFlag() {
        return this.borderFlag;
    }

    protected void updateCurrentPosition(MultiBorderLayout layout, MultiBorderConstraints relativePosition) {
        switch (relativePosition.gridy) {
            case -1: {
                ++this.gridy;
                break;
            }
            case -1000: {
                if (this.gridy >= 0) break;
                this.gridy = 0;
                break;
            }
            case -1001: {
                this.gridy = layout.getNbrRow(relativePosition.gridx);
                break;
            }
            default: {
                if (relativePosition.gridy < 0) {
                    this.gridy -= relativePosition.gridy;
                    break;
                }
                this.gridy = relativePosition.gridy;
            }
        }
        switch (relativePosition.gridx) {
            case -1: {
                ++this.gridx;
                break;
            }
            case -1000: {
                if (this.gridx >= 0) break;
                this.gridx = 0;
                break;
            }
            case -1001: {
                this.gridx = layout.getNbrColumn(this.gridy);
                break;
            }
            default: {
                if (relativePosition.gridx < 0) {
                    this.gridx -= relativePosition.gridx;
                    break;
                }
                this.gridx = relativePosition.gridx;
            }
        }
        this.gridwidth = relativePosition.gridwidth;
        this.gridheight = relativePosition.gridheight;
        this.weightx = relativePosition.weightx;
        this.weighty = relativePosition.weighty;
        this.anchor = relativePosition.anchor;
        this.fill = relativePosition.fill;
        this.insets = relativePosition.insets;
        this.borderFlag = this.borders == relativePosition.borders ? relativePosition.borderFlag : -1;
        this.borders = relativePosition.borders;
    }

    protected void initCurrentPosition() {
        this.gridx = -1;
        this.gridy = -1;
        this.gridwidth = 1;
        this.gridheight = 1;
    }
}

