/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.sf.sfac.gui.layout.CellInfo;
import net.sf.sfac.gui.layout.MultiBorderLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiBorder
implements Border {
    private static Log log = LogFactory.getLog(MultiBorder.class);
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Insets updatedInsets;
    protected Insets paintedBorderInsets;
    private int minCellX;
    private int maxCellX;
    private int minCellY;
    private int maxCellY;
    protected List<CellInfo> enclosedCells;
    protected List<Border> nestedBorders;
    private List<Component> borderComponents;
    protected Border paintedBorder;
    private Insets currentBorderSpace;
    private boolean borderVisible;
    private boolean borderEnabled;
    private boolean extraComponentsSealed;
    private MultiBorderLayout layout;

    public MultiBorder() {
        this(UIManager.getBorder("TitledBorder.border"));
    }

    public MultiBorder(String title) {
        this(new TitledBorder(title));
    }

    public MultiBorder(Border thePaintedBorder) {
        this.paintedBorder = thePaintedBorder;
        this.currentBorderSpace = new Insets(0, 0, 0, 0);
        this.borderVisible = true;
        this.borderEnabled = true;
        this.minCellX = Integer.MAX_VALUE;
        this.minCellY = Integer.MAX_VALUE;
        this.enclosedCells = new ArrayList<CellInfo>();
    }

    protected void setLayout(MultiBorderLayout ownerLayout) {
        this.layout = ownerLayout;
    }

    public boolean isBorderEnabled() {
        return this.borderEnabled;
    }

    protected void add(CellInfo cell) {
        this.enclosedCells.add(cell);
        this.setBorderAroundCell(cell);
    }

    private void setBorderAroundCell(CellInfo cell) {
        int gridx = cell.getGridX();
        int gridy = cell.getGridY();
        int lastx = gridx + cell.getGridWith() - 1;
        int lasty = gridy + cell.getGridHeight() - 1;
        if (this.minCellX > gridx) {
            this.minCellX = gridx;
        }
        if (this.maxCellX < lastx) {
            this.maxCellX = lastx;
        }
        if (this.minCellY > gridy) {
            this.minCellY = gridy;
        }
        if (this.maxCellY < lasty) {
            this.maxCellY = lasty;
        }
    }

    public boolean containsCell(CellInfo cell) {
        int cellX = cell.getGridX();
        int cellY = cell.getGridY();
        return this.minCellX <= cellX && cellX <= this.maxCellX && this.minCellY <= cellY && cellY <= this.maxCellY;
    }

    public boolean isEmpty() {
        for (int i = this.minCellX; i <= this.maxCellX; ++i) {
            for (int j = this.minCellY; j <= this.maxCellY; ++j) {
                CellInfo cell = this.layout.getCellInfo(i, j);
                if (cell == null || cell.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected void adaptCellSizes(Container c) {
        this.currentBorderSpace.top = 0;
        this.currentBorderSpace.left = 0;
        this.currentBorderSpace.bottom = 0;
        this.currentBorderSpace.right = 0;
        Insets insts = this.getBorderInsets(c);
        if (this.borderVisible && this.minCellX <= this.maxCellX && this.minCellY <= this.maxCellY) {
            for (int i = this.minCellX; i <= this.maxCellX; ++i) {
                CellInfo bottomCell;
                CellInfo topCell = this.layout.getCellInfo(i, this.minCellY);
                if (topCell != null && topCell.beginAt(i, this.minCellY)) {
                    int topSpace = topCell.getTopBorderSpace();
                    if (this.currentBorderSpace.top < topSpace) {
                        this.currentBorderSpace.top = topSpace;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Border " + this + " add " + insts.top + " space to cell " + topCell));
                    }
                    topCell.addTopBorderSpace(insts.top);
                }
                if ((bottomCell = this.layout.getCellInfo(i, this.maxCellY)) == null || !bottomCell.endAt(i, this.maxCellY)) continue;
                int bottomSpace = bottomCell.getBottomBorderSpace();
                if (this.currentBorderSpace.bottom < bottomSpace) {
                    this.currentBorderSpace.bottom = bottomSpace;
                }
                bottomCell.addBottomBorderSpace(insts.bottom);
            }
            for (int j = this.minCellY; j <= this.maxCellY; ++j) {
                CellInfo rightCell;
                CellInfo leftCell = this.layout.getCellInfo(this.minCellX, j);
                if (leftCell != null && leftCell.beginAt(this.minCellX, j)) {
                    int leftSpace = leftCell.getLeftBorderSpace();
                    if (this.currentBorderSpace.left < leftSpace) {
                        this.currentBorderSpace.left = leftSpace;
                    }
                    leftCell.addLeftBorderSpace(insts.left);
                }
                if ((rightCell = this.layout.getCellInfo(this.maxCellX, j)) == null || !rightCell.endAt(this.maxCellX, j)) continue;
                int rightSpace = rightCell.getRightBorderSpace();
                if (this.currentBorderSpace.right < rightSpace) {
                    this.currentBorderSpace.right = rightSpace;
                }
                rightCell.addRightBorderSpace(insts.right);
            }
        }
    }

    protected void layout(Container cont) {
        if (this.minCellX <= this.maxCellX && this.minCellY <= this.maxCellY && this.borderVisible) {
            this.x = this.layout.getColumnInfo((int)this.minCellX).pos + this.currentBorderSpace.left;
            this.y = this.layout.getRowInfo((int)this.minCellY).pos + this.currentBorderSpace.top;
            this.width = this.layout.getColumnInfo(this.maxCellX).getLayedNextPos() - this.x - this.currentBorderSpace.right;
            this.height = this.layout.getRowInfo(this.maxCellY).getLayedNextPos() - this.y - this.currentBorderSpace.bottom;
            this.sealExtraComponents();
            this.layoutExtraComponents(cont);
        } else {
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Layout border " + this.x + "," + this.y + " (" + this.width + "x" + this.height + ")"));
        }
    }

    protected void paint(Component c, Graphics g) {
        log.trace((Object)"Paint in MultiBorder");
        if (this.width > 0 && this.height > 0) {
            this.paintBorder(c, g, this.x, this.y, this.width, this.height);
        }
    }

    public void setBorderEnabled(boolean enabled) {
        this.sealExtraComponents();
        if (this.borderEnabled != enabled) {
            this.borderEnabled = enabled;
            int len = this.nestedBorders == null ? 0 : this.nestedBorders.size();
            for (int i = 0; i < len; ++i) {
                MultiBorder border = (MultiBorder)this.nestedBorders.get(i);
                border.setBorderEnabled(enabled);
            }
            if (this.borderComponents != null) {
                int nbrCmp = this.borderComponents.size();
                for (int i = 0; i < nbrCmp; ++i) {
                    Component cmp = this.borderComponents.get(i);
                    cmp.setEnabled(enabled);
                }
            }
        }
    }

    public void setBorderVisible(boolean visible) {
        this.sealExtraComponents();
        if (this.borderVisible != visible) {
            this.borderVisible = visible;
            int len = this.nestedBorders == null ? 0 : this.nestedBorders.size();
            for (int i = 0; i < len; ++i) {
                MultiBorder border = (MultiBorder)this.nestedBorders.get(i);
                border.setBorderVisible(visible);
            }
            if (this.borderComponents != null) {
                for (Component cmp : this.borderComponents) {
                    cmp.setVisible(visible);
                }
            }
        }
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    protected void setNestedBorder(MultiBorder border) {
        if (this.nestedBorders == null) {
            this.nestedBorders = new ArrayList<Border>();
        }
        if (!this.nestedBorders.contains(border)) {
            this.nestedBorders.add(border);
        }
    }

    public String toString() {
        String title = "";
        title = this.paintedBorder == null ? "null" : (this.paintedBorder instanceof TitledBorder ? ((TitledBorder)this.paintedBorder).getTitle() : this.paintedBorder.getClass().getName());
        return this.getClass().getName() + "['" + title + "']";
    }

    protected void addExtraComponents(Container cont) {
        this.sealExtraComponents();
        if (this.borderComponents != null) {
            for (Component cmp : this.borderComponents) {
                cont.add(cmp, this);
            }
        }
    }

    protected void layoutExtraComponents(Container cont) {
    }

    private void sealExtraComponents() {
        if (!this.extraComponentsSealed) {
            this.registerExtraComponents();
        }
        this.extraComponentsSealed = true;
    }

    protected void registerExtraComponents() {
    }

    protected void registerExtraComponent(Component cmp) {
        if (this.extraComponentsSealed) {
            throw new IllegalStateException("Border components must be addedbefore the first time the border is shown");
        }
        if (this.borderComponents == null) {
            this.borderComponents = new ArrayList<Component>();
        }
        this.borderComponents.add(cmp);
    }

    protected Insets getUpdatedInsets(Component cmp) {
        if (this.updatedInsets == null) {
            this.createCachedInsets(cmp);
        }
        return this.updatedInsets;
    }

    protected Insets getPaintedBorderInsets(Component cmp) {
        if (this.paintedBorderInsets == null) {
            this.createCachedInsets(cmp);
        }
        return this.paintedBorderInsets;
    }

    private void createCachedInsets(Component cmp) {
        this.paintedBorderInsets = this.paintedBorder.getBorderInsets(cmp);
        this.updatedInsets = (Insets)this.paintedBorderInsets.clone();
        this.updateInsets(this.updatedInsets);
    }

    protected void updateInsets(Insets insetToUpdate) {
    }

    public void paintBorder(Component c, Graphics g, int x1, int y1, int width1, int height1) {
        int leftGap = (this.updatedInsets.left - this.paintedBorderInsets.left) / 2;
        int rightGap = (this.updatedInsets.right - this.paintedBorderInsets.right) / 2;
        int topGap = (this.updatedInsets.top - this.paintedBorderInsets.top) / 2;
        int bottomGap = (this.updatedInsets.bottom - this.paintedBorderInsets.bottom) / 2;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adjust multi border to " + (x1 + leftGap) + "," + (y1 + topGap) + " (" + (width1 - (leftGap + rightGap)) + "x" + (height1 - (topGap + bottomGap)) + ")"));
        }
        this.paintedBorder.paintBorder(c, g, x1 + leftGap, y1 + topGap, width1 - (leftGap + rightGap), height1 - (topGap + bottomGap));
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.getUpdatedInsets(c).clone();
    }

    public boolean isBorderOpaque() {
        return this.paintedBorder.isBorderOpaque();
    }

    public void dispose(Container cont) {
        if (this.borderComponents != null) {
            if (cont != null) {
                int len = this.borderComponents.size();
                for (int i = 0; i < len; ++i) {
                    JComponent cmp = (JComponent)this.borderComponents.get(i);
                    cont.remove(cmp);
                }
            }
            this.borderComponents.clear();
        }
        this.extraComponentsSealed = false;
        this.enclosedCells.clear();
        this.nestedBorders = null;
        this.layout = null;
    }
}

