/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import net.sf.sfac.gui.layout.MultiBorderConstraints;

class ComponentInfo {
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private Component comp;
    private int width;
    private int height;
    int filledWidth;
    int filledHeight;
    private int anchor;
    private int fill;
    private Insets inset;

    ComponentInfo(Component cmp, MultiBorderConstraints constr) {
        this.comp = cmp;
        this.anchor = constr.anchor;
        this.fill = constr.fill;
        this.inset = constr.insets == null ? NULL_INSETS : (Insets)constr.insets.clone();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getFill() {
        return this.fill;
    }

    public void calculateSize() {
        Dimension dim = this.comp.getPreferredSize();
        this.width = dim.width + this.inset.left + this.inset.right;
        this.height = dim.height + this.inset.top + this.inset.bottom;
    }

    public void layout(int startX, int startY) {
        int posX = startX + this.inset.left;
        int posY = startY + this.inset.top;
        int cmpWidth = this.filledWidth - (this.inset.left + this.inset.right);
        int cmpHeight = this.filledHeight - (this.inset.top + this.inset.bottom);
        this.comp.setBounds(posX, posY, cmpWidth, cmpHeight);
    }

    protected void setEnabled(boolean enabled) {
        this.comp.setEnabled(enabled);
    }

    protected void setVisible(boolean visible) {
        this.comp.setVisible(visible);
    }

    boolean checkComponent(Component cmp) {
        return cmp == this.comp;
    }
}

