/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.sf.sfac.gui.layout.ActionBorder;

public class CheckBoxBorder
extends ActionBorder {
    private JCheckBox checkBox;

    public CheckBoxBorder(String title, int borderAction) {
        super(UIManager.getBorder("TitledBorder.border"));
        this.init(title, borderAction);
    }

    public CheckBoxBorder(Border thePaintedBorder, String title, int borderAction) {
        super(thePaintedBorder);
        this.init(title, borderAction);
    }

    private void init(String title, int action) {
        this.setBorderAction(action);
        this.checkBox = new JCheckBox(title);
        this.checkBox.setSelected(true);
        this.setControlButton(this.checkBox);
    }

    public String toString() {
        return this.getClass().getName() + "['" + this.checkBox.getText() + "']";
    }

    protected void updateInsets(Insets insetToUpdate) {
        insetToUpdate.top += 4;
        insetToUpdate.left += 4;
        insetToUpdate.bottom += 4;
        insetToUpdate.right += 4;
        super.updateInsets(insetToUpdate);
    }

    protected void layoutExtraComponents(Container cont) {
        Dimension dim = this.checkBox.getPreferredSize();
        int posX = this.x + 6;
        int posY = this.y + (this.getUpdatedInsets((Component)cont).top - dim.height) / 2;
        this.checkBox.setBounds(posX, posY, dim.width, dim.height);
    }
}

