/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Component;
import java.awt.Insets;
import java.util.Iterator;
import net.sf.sfac.gui.layout.ComponentInfo;
import net.sf.sfac.gui.layout.LineInfo;
import net.sf.sfac.gui.layout.MultiBorder;
import net.sf.sfac.gui.layout.MultiBorderConstraints;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CellInfo {
    private static Log log = LogFactory.getLog(CellInfo.class);
    public static final int COLLAPSED_NONE = 0;
    public static final int COLLAPSED_VERTICAL = 1;
    public static final int COLLAPSED_HORIZONTAL = 2;
    private int gridx;
    private int gridy;
    private int gridwidth;
    private int gridheight;
    private double weightx;
    private double weighty;
    private ComponentInfo[] cmpInfos;
    private int nbrCmp;
    private int nbrFillX;
    private Insets borderSpace;
    private int cellCollapsed;
    private boolean cellEnabled;
    private int width;
    private int height;

    public CellInfo(MultiBorderConstraints constr) {
        this.gridx = constr.gridx;
        this.gridy = constr.gridy;
        this.gridwidth = constr.gridwidth;
        this.gridheight = constr.gridheight;
        this.weightx = constr.weightx;
        this.weighty = constr.weighty;
        this.cmpInfos = new ComponentInfo[1];
        this.borderSpace = new Insets(0, 0, 0, 0);
        this.cellEnabled = true;
    }

    public void addComponent(Component cmp, MultiBorderConstraints constr) {
        int len = this.cmpInfos.length;
        if (this.nbrCmp == len) {
            int newLen = len + 3;
            ComponentInfo[] newCmpInfos = new ComponentInfo[newLen];
            System.arraycopy(this.cmpInfos, 0, newCmpInfos, 0, len);
            this.cmpInfos = newCmpInfos;
        }
        if (this.nbrCmp == 0) {
            Iterator<MultiBorder> it = constr.getBordersIterator();
            while (it.hasNext()) {
                MultiBorder border = it.next();
                border.add(this);
            }
        }
        cmp.setVisible(this.cellCollapsed == 0);
        cmp.setEnabled(this.cellEnabled);
        this.cmpInfos[this.nbrCmp] = new ComponentInfo(cmp, constr);
        ++this.nbrCmp;
        if (this.weightx < constr.weightx) {
            this.weightx = constr.weightx;
        }
        if (this.weighty < constr.weighty) {
            this.weighty = constr.weighty;
        }
        if (constr.fill == 2 || constr.fill == 1) {
            ++this.nbrFillX;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGridX() {
        return this.gridx;
    }

    public int getLastX() {
        return this.gridx + this.gridwidth - 1;
    }

    public int getGridY() {
        return this.gridy;
    }

    public int getLastY() {
        return this.gridy + this.gridheight - 1;
    }

    public int getGridWith() {
        return this.gridwidth;
    }

    public int getGridHeight() {
        return this.gridheight;
    }

    public double getWeightX() {
        return this.weightx;
    }

    public double getWeightY() {
        return this.weighty;
    }

    public boolean beginAt(int x, int y) {
        return this.gridx == x && this.gridy == y;
    }

    public boolean endAt(int x, int y) {
        return this.getLastX() == x && this.getLastY() == y;
    }

    public int getTotalWidth() {
        return this.borderSpace.left + this.width + this.borderSpace.right;
    }

    public int getTotalHeight() {
        return this.borderSpace.top + this.height + this.borderSpace.bottom;
    }

    public int getTopBorderSpace() {
        return this.borderSpace.top;
    }

    public int getLeftBorderSpace() {
        return this.borderSpace.left;
    }

    public int getBottomBorderSpace() {
        return this.borderSpace.bottom;
    }

    public int getRightBorderSpace() {
        return this.borderSpace.right;
    }

    public void addTopBorderSpace(int space) {
        this.borderSpace.top += space;
    }

    public void addLeftBorderSpace(int space) {
        this.borderSpace.left += space;
    }

    public void addBottomBorderSpace(int space) {
        this.borderSpace.bottom += space;
    }

    public void addRightBorderSpace(int space) {
        this.borderSpace.right += space;
    }

    public void resetBorder() {
        this.borderSpace.top = 0;
        this.borderSpace.left = 0;
        this.borderSpace.bottom = 0;
        this.borderSpace.right = 0;
    }

    public void calculateSize() {
        this.height = 0;
        this.width = 0;
        if (this.nbrCmp > 0) {
            for (int i = 0; i < this.nbrCmp; ++i) {
                ComponentInfo cmpInfo = this.cmpInfos[i];
                cmpInfo.calculateSize();
                if ((this.cellCollapsed & 2) == 0) {
                    this.width += cmpInfo.getWidth();
                }
                if ((this.cellCollapsed & 1) != 0 || cmpInfo.getHeight() <= this.height) continue;
                this.height = cmpInfo.getHeight();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cell (" + this.gridx + " - " + this.gridy + ") size calculated: " + this.width + "x" + this.height + " (borders t:" + this.borderSpace.top + ",l:" + this.borderSpace.left + ",b:" + this.borderSpace.bottom + ",r:" + this.borderSpace.right + ")"));
        }
    }

    public void balanceExtraSize(LineInfo[] colInfos, LineInfo[] rowInfos) {
        int i;
        int i2;
        if (this.gridwidth > 1) {
            int existingWidth = 0;
            int gridLastX = this.getLastX();
            for (i2 = this.gridx; i2 <= gridLastX; ++i2) {
                existingWidth += colInfos[i2].getTotalSpace();
            }
            existingWidth -= colInfos[this.gridx].beforeSpace;
            if (this.width > (existingWidth -= colInfos[gridLastX].afterSpace)) {
                int neededWidth = this.width - existingWidth;
                int addedWidth = neededWidth / this.gridwidth;
                for (i = this.gridx; i < gridLastX; ++i) {
                    colInfos[i].space += addedWidth;
                }
                colInfos[gridLastX].space += neededWidth - addedWidth * (this.gridwidth - 1);
            }
        }
        if (this.gridheight > 1) {
            int existingHeight = 0;
            int gridLastY = this.getLastY();
            for (i2 = this.gridy; i2 <= gridLastY; ++i2) {
                existingHeight += rowInfos[i2].getTotalSpace();
            }
            existingHeight -= rowInfos[this.gridy].beforeSpace;
            existingHeight -= rowInfos[gridLastY].afterSpace;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Height check: existing=" + existingHeight + ", needed=" + this.height));
            }
            if (this.height > existingHeight) {
                int neededHeight = this.height - existingHeight;
                int addedHeight = neededHeight / this.gridheight;
                for (i = this.gridy; i < gridLastY; ++i) {
                    rowInfos[i].space += addedHeight;
                }
                rowInfos[gridLastY].space += neededHeight - addedHeight * (this.gridheight - 1);
            }
        }
    }

    public void layout(LineInfo[] colInfos, LineInfo[] rowInfos) {
        int posX;
        int startX = colInfos[this.gridx].getLayedStart();
        int layWidth = colInfos[this.gridx + this.gridwidth - 1].getLayedEnd() - startX;
        int startY = rowInfos[this.gridy].getLayedStart();
        int layHeight = rowInfos[this.gridy + this.gridheight - 1].getLayedEnd() - startY;
        int totalWidth = this.nbrFillX == 0 ? this.width : layWidth;
        int freeXSpace = this.nbrFillX == 0 ? 0 : layWidth - this.width;
        int extraXSpace = freeXSpace <= 0 ? 0 : freeXSpace / this.nbrFillX;
        int modulo = freeXSpace <= 0 ? 0 : freeXSpace % this.nbrFillX;
        for (int i = 0; i < this.nbrCmp; ++i) {
            ComponentInfo cmpInfo = this.cmpInfos[i];
            int cmpFill = cmpInfo.getFill();
            if (cmpFill == 2 || cmpFill == 1) {
                cmpInfo.filledWidth = extraXSpace > 0 ? cmpInfo.getWidth() + extraXSpace : cmpInfo.getWidth();
                if (modulo > 0) {
                    ++cmpInfo.filledWidth;
                    --modulo;
                }
            } else {
                cmpInfo.filledWidth = cmpInfo.getWidth();
            }
            cmpInfo.filledHeight = cmpFill == 3 || cmpFill == 1 ? layHeight : cmpInfo.getHeight();
        }
        int anchor = this.nbrCmp > 0 ? this.cmpInfos[0].getAnchor() : 0;
        switch (anchor) {
            case 10: 
            case 11: 
            case 15: {
                posX = startX + (layWidth - totalWidth) / 2;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                posX = startX + (layWidth - totalWidth);
                break;
            }
            default: {
                posX = startX;
            }
        }
        for (int i = 0; i < this.nbrCmp; ++i) {
            int posY;
            ComponentInfo cmpInfo = this.cmpInfos[i];
            switch (cmpInfo.getAnchor()) {
                case 14: 
                case 15: 
                case 16: {
                    posY = startY;
                    break;
                }
                default: {
                    posY = startY + (layHeight - cmpInfo.filledHeight) / 2;
                    break;
                }
                case 11: 
                case 12: 
                case 18: {
                    posY = startY + (layHeight - cmpInfo.filledHeight);
                }
            }
            cmpInfo.layout(posX, posY);
            posX += cmpInfo.filledWidth;
        }
    }

    public String toString() {
        return "c(" + this.gridx + "," + this.gridy + ")-" + this.width + "x" + this.height;
    }

    public void setEnabled(boolean enabled) {
        if (this.cellEnabled != enabled) {
            this.cellEnabled = enabled;
            for (int i = 0; i < this.nbrCmp; ++i) {
                this.cmpInfos[i].setEnabled(enabled);
            }
        }
    }

    public void setCollapsed(int newCollapsed) {
        if (this.cellCollapsed != newCollapsed) {
            for (int i = 0; i < this.nbrCmp; ++i) {
                this.cmpInfos[i].setVisible(newCollapsed == 0);
            }
            this.cellCollapsed = newCollapsed;
        }
    }

    public boolean isCollapsed() {
        return this.cellCollapsed != 0;
    }

    boolean removeLayoutComponent(Component comp) {
        for (int i = 0; i < this.nbrCmp; ++i) {
            if (!this.cmpInfos[i].checkComponent(comp)) continue;
            if (i < this.nbrCmp - 1) {
                System.arraycopy(this.cmpInfos, i + 1, this.cmpInfos, i, this.nbrCmp - (i + 1));
            }
            --this.nbrCmp;
            this.cmpInfos[this.nbrCmp] = null;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.nbrCmp == 0;
    }
}

