/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.sf.sfac.gui.layout.CellInfo;
import net.sf.sfac.gui.layout.MultiBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionBorder
extends MultiBorder
implements ActionListener {
    private static Log log = LogFactory.getLog(ActionBorder.class);
    public static final int CONTROL_BUTTON_SPACE = 6;
    public static final int ACTION_COLLAPSE = 0;
    public static final int ACTION_DISABLE = 1;
    private AbstractButton controlButton;
    private int borderAction;
    private Container parentContainer;
    private boolean isExpanded = true;
    private boolean isContentEnabled = true;

    public ActionBorder() {
    }

    public ActionBorder(String title) {
        super(title);
    }

    public ActionBorder(Border thePaintedBorder) {
        super(thePaintedBorder);
    }

    protected void setControlButton(AbstractButton button) {
        this.controlButton = button;
    }

    protected void setBorderAction(int action) {
        this.borderAction = action;
    }

    public void setContentEnabled(boolean enabled) {
        if (this.isContentEnabled != enabled) {
            int i;
            this.isContentEnabled = enabled;
            int len = this.enclosedCells.size();
            for (i = 0; i < len; ++i) {
                CellInfo cell = (CellInfo)this.enclosedCells.get(i);
                cell.setEnabled(enabled);
            }
            len = this.nestedBorders == null ? 0 : this.nestedBorders.size();
            for (i = 0; i < len; ++i) {
                MultiBorder border = (MultiBorder)this.nestedBorders.get(i);
                border.setBorderEnabled(enabled);
            }
            if (this.controlButton != null) {
                this.controlButton.setSelected(enabled);
            }
            if (this.parentContainer != null) {
                this.parentContainer.repaint();
            }
        }
    }

    public void setBorderExpanded(boolean expanded) {
        if (this.isExpanded != expanded) {
            int i;
            this.isExpanded = expanded;
            int len = this.enclosedCells.size();
            for (i = 0; i < len; ++i) {
                CellInfo cell = (CellInfo)this.enclosedCells.get(i);
                cell.setCollapsed(this.isExpanded ? 0 : 1);
            }
            len = this.nestedBorders == null ? 0 : this.nestedBorders.size();
            for (i = 0; i < len; ++i) {
                MultiBorder border = (MultiBorder)this.nestedBorders.get(i);
                border.setBorderVisible(expanded);
            }
            if (this.controlButton != null) {
                this.controlButton.setSelected(this.isExpanded);
            }
            this.relayout();
        }
    }

    private void relayout() {
        if (this.parentContainer != null) {
            if (this.parentContainer instanceof JComponent) {
                ((JComponent)this.parentContainer).revalidate();
            } else {
                this.parentContainer.invalidate();
            }
            this.parentContainer.repaint();
        }
    }

    public void setSelected(boolean selected) {
        if (this.controlButton != null) {
            this.controlButton.setSelected(selected);
        }
        switch (this.borderAction) {
            case 0: {
                this.setBorderExpanded(selected);
                break;
            }
            default: {
                this.setContentEnabled(selected);
            }
        }
    }

    public boolean isSelected() {
        switch (this.borderAction) {
            case 0: {
                return this.isExpanded;
            }
        }
        return this.isContentEnabled;
    }

    protected void setNestedBorder(MultiBorder border) {
        super.setNestedBorder(border);
        border.setBorderVisible(this.isExpanded);
        border.setBorderEnabled(this.isContentEnabled);
    }

    protected void addExtraComponents(Container cont) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addComponents : Got parentContainer : " + cont.getClass()));
        }
        this.parentContainer = cont;
        super.addExtraComponents(cont);
    }

    protected void add(CellInfo cell) {
        super.add(cell);
        cell.setCollapsed(this.isExpanded ? 0 : 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MultiBorder add cell " + cell + " with content enabled = " + this.isContentEnabled));
        }
        cell.setEnabled(this.isContentEnabled);
    }

    public void setBorderEnabled(boolean enabled) {
        boolean wasEnabled = this.isBorderEnabled();
        super.setBorderEnabled(enabled);
        if (wasEnabled != enabled && enabled && !this.isContentEnabled) {
            this.isContentEnabled = true;
            this.setContentEnabled(false);
        }
    }

    public void setBorderVisible(boolean visible) {
        boolean wasVisible = this.isBorderVisible();
        super.setBorderVisible(visible);
        if (wasVisible != visible && visible && !this.isExpanded) {
            this.isExpanded = true;
            this.setBorderExpanded(false);
        }
    }

    protected void layout(Container cont) {
        super.layout(cont);
        if (!this.isExpanded) {
            Insets inset = this.getBorderInsets(cont);
            this.height = inset.top + inset.bottom;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Layout collapsed MultiBorder " + this.x + "," + this.y + " (" + this.width + "x" + this.height + ")"));
            }
        }
    }

    protected void registerExtraComponents() {
        if (this.controlButton != null) {
            this.registerExtraComponent(this.controlButton);
            this.controlButton.addActionListener(this);
        }
    }

    protected void layoutExtraComponents(Container cont) {
        if (this.controlButton != null) {
            Dimension dim = this.controlButton.getPreferredSize();
            int posX = this.x + this.width - 6 - dim.width;
            int posY = this.y + (this.getUpdatedInsets((Component)cont).top - dim.height) / 2;
            this.controlButton.setBounds(posX, posY, dim.width, dim.height);
        }
    }

    protected void updateInsets(Insets insetToUpdate) {
        if (this.controlButton != null) {
            Dimension dim = this.controlButton.getPreferredSize();
            if (insetToUpdate.top < dim.height) {
                insetToUpdate.top = dim.height;
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.controlButton) {
            boolean selected = this.controlButton.isSelected();
            switch (this.borderAction) {
                case 0: {
                    this.setBorderExpanded(selected);
                    break;
                }
                default: {
                    this.setContentEnabled(selected);
                }
            }
        }
    }
}

