/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedResources {
    private static Log log = LogFactory.getLog(SharedResources.class);
    private static final String DEFAULT_BASE_IMAGE_LOCATION = "/net/sf/sfac/images";
    private static List<String> imageLocations;
    private static Map<String, Object> resources;
    private static SharedResources instance;

    private SharedResources() {
    }

    public static void addBaseImageLocation(String newLocation) {
        imageLocations.add(newLocation);
    }

    public static List<String> getBaseImageLocations() {
        return imageLocations;
    }

    public static ImageIcon getIcon(String iconPath) {
        return SharedResources.getIcon(iconPath, null, null);
    }

    public static ImageIcon getIcon(String iconPath, Class<?> baseClass) {
        return SharedResources.getIcon(iconPath, null, baseClass);
    }

    public static ImageIcon getIcon(String iconPath, String defaultIconPath) {
        return SharedResources.getIcon(iconPath, defaultIconPath, null);
    }

    public static ImageIcon getIcon(String iconPath, String defaultIconPath, Class<?> baseClass) {
        ImageIcon ico = (ImageIcon)resources.get(iconPath);
        if (ico == null) {
            URL imageURL = SharedResources.getResourceURL(iconPath, baseClass);
            if (imageURL == null) {
                if (defaultIconPath == null) {
                    throw new IllegalArgumentException("Image not found in classpath: " + iconPath + " [classLoader = " + SharedResources.getClassLoader(baseClass) + "]");
                }
                return SharedResources.getIcon(defaultIconPath, null, baseClass);
            }
            try {
                ico = new ImageIcon(imageURL);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid image in URL: " + iconPath, e);
            }
            resources.put(iconPath, ico);
        }
        return ico;
    }

    public static URL getResourceURL(String path, Class<?> baseClass) {
        URL resourceURL = null;
        if (baseClass == null) {
            baseClass = instance.getClass();
        }
        if (path.startsWith("/")) {
            resourceURL = baseClass.getResource(path);
        } else {
            String basePath;
            String fullPath;
            Iterator<String> i$ = imageLocations.iterator();
            while (i$.hasNext() && (resourceURL = baseClass.getResource(fullPath = (basePath = i$.next()) + "/" + path)) == null) {
            }
            if (log.isDebugEnabled() && resourceURL == null) {
                log.debug((Object)("Resource: " + path + " not found in " + imageLocations));
            }
        }
        return resourceURL;
    }

    public static String getResourcePath(Object resource) {
        for (Map.Entry<String, Object> e : resources.entrySet()) {
            if (e.getValue() != resource) continue;
            return e.getKey();
        }
        return null;
    }

    private static ClassLoader getClassLoader(Class<?> baseClass) {
        if (baseClass == null) {
            baseClass = instance.getClass();
        }
        return baseClass.getClassLoader();
    }

    public static boolean iconExists(String iconPath) {
        return SharedResources.iconExists(iconPath, null);
    }

    public static boolean iconExists(String iconPath, Class<?> baseClass) {
        boolean exists = true;
        Object res = resources.get(iconPath);
        if (res == null) {
            exists = SharedResources.getResourceURL(iconPath, baseClass) != null;
        }
        return exists;
    }

    static {
        resources = new HashMap<String, Object>();
        instance = new SharedResources();
        imageLocations = new ArrayList<String>();
        imageLocations.add(DEFAULT_BASE_IMAGE_LOCATION);
    }
}

