/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;

public class MnemonicManager {
    private List<Set<Integer>> mnemonics = new ArrayList<Set<Integer>>();

    public void reset() {
        this.mnemonics.clear();
    }

    public void clear(int fromLevel) {
        for (int i = this.mnemonics.size() - 1; i >= fromLevel; --i) {
            this.mnemonics.remove(i);
        }
    }

    public void assignActionMnemonic(Action act) {
        this.assignActionMnemonic(act, 0);
    }

    public void assignActionMnemonic(Action act, int level) {
        String text = (String)act.getValue("Name");
        Integer mnemonic = this.getMnemonic(text, level);
        act.putValue("MnemonicKey", mnemonic);
    }

    public void assignLabelMnemonic(JLabel lbl) {
        this.assignLabelMnemonic(lbl, 0);
    }

    public void assignLabelMnemonic(JLabel lbl, int level) {
        String text = lbl.getText();
        Integer mnemonic = this.getMnemonic(text, level);
        lbl.setDisplayedMnemonic(mnemonic == null ? 0 : mnemonic);
    }

    public void assignButtonMnemonic(AbstractButton but) {
        this.assignButtonMnemonic(but, 0);
    }

    public void assignButtonMnemonic(AbstractButton but, int level) {
        String text = but.getText();
        Integer mnemonic = this.getMnemonic(text, level);
        but.setMnemonic(mnemonic == null ? 0 : mnemonic);
    }

    private void checkArray(int level) {
        int len = this.mnemonics.size();
        int missingCount = level - len + 1;
        for (int i = 0; i < missingCount; ++i) {
            this.mnemonics.add(new HashSet());
        }
    }

    private Integer getMnemonic(String text, int level) {
        this.checkArray(level);
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = Character.toUpperCase(text.charAt(i));
            Integer charact = ch;
            boolean notUsed = true;
            for (int j = 0; j <= level; ++j) {
                if (!this.mnemonics.get(j).contains(charact)) continue;
                notUsed = false;
                break;
            }
            if (!notUsed) continue;
            this.mnemonics.get(level).add(charact);
            return charact;
        }
        return null;
    }
}

