/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.utils.ThinMetalTheme;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookAndFeelHelper {
    private static Log log = LogFactory.getLog(LookAndFeelHelper.class);
    private static final String METAL_LF_CLASS = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String LOOK_AND_FEEL_KEY = "frame.lookAndFeel";
    private Component rootUiComponent;
    private Action[] lookAndFeelActions;
    private static String currentLookAndFeel;
    private Settings setts;

    public LookAndFeelHelper(Settings sett) {
        this.setts = sett;
        if (this.setts != null) {
            this.restoreLookAndFeel();
        }
    }

    public void setRootUiComponent(Component root) {
        this.rootUiComponent = root;
    }

    private void restoreLookAndFeel() {
        String defaultLookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
        String startLookAndFeel = this.setts.getStringProperty(LOOK_AND_FEEL_KEY, defaultLookAndFeel);
        try {
            LookAndFeelHelper.setLookAndFeel(startLookAndFeel);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(null, "Look & Feel error", "Cannot set look & feel:\n" + startLookAndFeel + "\n -> Will use default one.", e);
        }
    }

    public static void setLookAndFeel(String lookAndFeelName) throws Exception {
        String lookAndFeelClassName;
        log.debug((Object)("Set look and feel to: " + lookAndFeelName));
        String themeName = null;
        int dollarIndex = lookAndFeelName.indexOf(36);
        if (dollarIndex > 0) {
            lookAndFeelClassName = lookAndFeelName.substring(0, dollarIndex);
            themeName = lookAndFeelName.substring(dollarIndex + 1);
        } else {
            lookAndFeelClassName = lookAndFeelName;
        }
        if (METAL_LF_CLASS.equals(lookAndFeelClassName)) {
            if (themeName != null) {
                MetalLookAndFeel.setCurrentTheme(new ThinMetalTheme());
            } else {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
        }
        UIManager.setLookAndFeel(lookAndFeelClassName);
        currentLookAndFeel = lookAndFeelName;
    }

    public void updateLookAndFeel(String lookAndFeelName) {
        block5: {
            if (this.rootUiComponent == null) {
                throw new IllegalStateException("No Root Ui Component set");
            }
            try {
                Action lfAction;
                LookAndFeelHelper.setLookAndFeel(lookAndFeelName);
                SwingUtilities.updateComponentTreeUI(this.rootUiComponent);
                if (this.setts != null) {
                    this.setts.setStringProperty(LOOK_AND_FEEL_KEY, lookAndFeelName);
                }
                if ((lfAction = this.getLookAndFeelAction(lookAndFeelName)) != null) {
                    ActionRepository.setActionSelected(lfAction, true);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Look And Feel not available: " + lookAndFeelName), (Throwable)e);
                Action lfAction = this.getLookAndFeelAction(lookAndFeelName);
                if (lfAction == null) break block5;
                lfAction.setEnabled(false);
            }
        }
    }

    private Action getLookAndFeelAction(String lookAndFeelClassName) {
        int len = this.lookAndFeelActions.length;
        for (int i = 0; i < len; ++i) {
            String actName = (String)this.lookAndFeelActions[i].getValue("Name");
            if (!actName.equals(lookAndFeelClassName)) continue;
            return this.lookAndFeelActions[i];
        }
        return null;
    }

    public void createActions(ActionRepository repo, String menuName, String menuGroup, String toolbarGroup) {
        Action act;
        int slashIndex;
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        if (currentLookAndFeel == null) {
            currentLookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        ButtonGroup butGroup = new ButtonGroup();
        int infoLen = infos.length;
        int len = infoLen + 1;
        this.lookAndFeelActions = new Action[len];
        for (int i = 0; i < len; ++i) {
            String className = i < infoLen ? infos[i].getClassName() : "javax.swing.plaf.metal.MetalLookAndFeel$Thin";
            String shortDesc = i < infoLen ? infos[i].getName() : "Thin Metal";
            this.lookAndFeelActions[i] = repo.addAction(className, shortDesc, null, menuName, menuGroup, toolbarGroup, null, new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    LookAndFeelHelper.this.updateLookAndFeel((String)this.getValue("ActionID"));
                }
            });
            ActionRepository.setRadioAction(this.lookAndFeelActions[i], butGroup);
            ActionRepository.setActionSelected(this.lookAndFeelActions[i], className.equals(currentLookAndFeel));
        }
        if (menuName != null && (slashIndex = menuName.lastIndexOf(47)) >= 0 && (act = repo.getAction(menuName.substring(slashIndex + 1))) != null && act.getValue("SmallIcon") == null) {
            ImageIcon icon = SharedResources.getIcon("lookAndFeel.png");
            act.putValue("SmallIcon", icon);
        }
    }
}

