/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LanguageHelper {
    public static final String LANGUAGE_KEY = "app.language";
    private static Log log = LogFactory.getLog(LanguageHelper.class);
    private String[] supportedLocaleIds;
    private Action[] languageActions;
    private Settings setts;

    public LanguageHelper(Settings sett, String[] supportedLocaleIDs) {
        String localeId;
        LanguageSupport.addLanguageListener((LanguageListener)new LanguageListener(){

            public void languageChanged(Locale newLocale) {
                LanguageHelper.this.languageChangedToLocale(newLocale);
            }
        });
        this.setts = sett;
        this.supportedLocaleIds = supportedLocaleIDs;
        if (this.setts != null && (localeId = this.setts.getStringProperty(LANGUAGE_KEY, null)) != null) {
            LanguageSupport.updateLanguage((String)localeId);
        }
    }

    public Settings getSettings() {
        return this.setts;
    }

    private Action getLanguageAction(String localeId) {
        int len = this.supportedLocaleIds.length;
        for (int i = 0; i < len; ++i) {
            if (!localeId.equals(this.supportedLocaleIds[i])) continue;
            return this.languageActions[i];
        }
        return null;
    }

    void languageChangedToLocale(Locale newLocale) {
        Action act;
        String localeId = newLocale.toString();
        if (this.setts != null) {
            this.setts.setStringProperty(LANGUAGE_KEY, localeId);
        }
        if ((act = this.getLanguageAction(localeId)) != null) {
            if (!ActionRepository.isActionSelected(act)) {
                ActionRepository.setActionSelected(act, true);
            }
        } else {
            log.warn((Object)("Unknown locale ID in LanguageHelper: " + localeId));
        }
    }

    public void createActions(ActionRepository repo, String menuPath, String menuGroup, String toolbarGroup) {
        Action act;
        int slashIndex;
        String startLocaleId = LanguageSupport.getCurrentLocale().toString();
        ButtonGroup butGroup = new ButtonGroup();
        int len = this.supportedLocaleIds.length;
        this.languageActions = new Action[len];
        for (int i = 0; i < len; ++i) {
            this.languageActions[i] = repo.addAction(this.supportedLocaleIds[i], menuPath, menuGroup, toolbarGroup, null, new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    LanguageSupport.updateLanguage((String)((String)this.getValue("ActionID")));
                }
            });
            ActionRepository.setRadioAction(this.languageActions[i], butGroup);
            ActionRepository.setActionSelected(this.languageActions[i], this.supportedLocaleIds[i].equals(startLocaleId));
        }
        if (menuPath != null && (slashIndex = menuPath.lastIndexOf(47)) >= 0 && (act = repo.getAction(menuPath.substring(slashIndex + 1))) != null && act.getValue("SmallIcon") == null) {
            ImageIcon icon = SharedResources.getIcon("language.png");
            act.putValue("SmallIcon", icon);
        }
    }
}

