/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationFrame
extends JFrame
implements LanguageListener {
    private static Log log = LogFactory.getLog(ApplicationFrame.class);
    private static final String FRAME_BOUNDS_KEY = ".bounds";
    private static final String FRAME_MAXIMIZED_KEY = ".maximized";
    private static final String VIEW_TOOLBAR_KEY = ".view.toolBar";
    private static final Rectangle DEFAULT_BOUNDS = new Rectangle(20, 20, 850, 650);
    private JToolBar toolBar;
    Settings setts;
    private Action viewToolbarAction;
    private boolean toolbarVisible;

    public ApplicationFrame(Settings sett) {
        this(LanguageSupport.getLocalizedString((String)"FRAME_TITLE"), sett);
        LanguageSupport.addLanguageListener((LanguageListener)this);
    }

    public ApplicationFrame(String title, Settings sett) {
        this.setts = sett;
        this.setTitle(title);
        this.toolbarVisible = true;
        if (this.setts != null) {
            this.setFrameBounds();
        } else {
            this.setBounds(DEFAULT_BOUNDS);
        }
    }

    public Settings getSettings() {
        return this.setts;
    }

    protected String getKeyPrefix() {
        return "frame";
    }

    private void setFrameBounds() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set frame bounds to: " + this.setts.getRectangleProperty(this.getKeyPrefix() + FRAME_BOUNDS_KEY, DEFAULT_BOUNDS)));
        }
        this.setBounds(this.setts.getRectangleProperty(this.getKeyPrefix() + FRAME_BOUNDS_KEY, DEFAULT_BOUNDS));
        if (this.setts.getBooleanProperty(this.getKeyPrefix() + FRAME_MAXIMIZED_KEY, false)) {
            this.setExtendedState(6);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ApplicationFrame.this.storeFrameBounds();
            }

            public void componentMoved(ComponentEvent e) {
                ApplicationFrame.this.storeFrameBounds();
            }
        });
    }

    void storeFrameBounds() {
        boolean maximized;
        boolean bl = maximized = this.getExtendedState() == 6;
        if (!maximized) {
            this.setts.setRectangleProperty(this.getKeyPrefix() + FRAME_BOUNDS_KEY, this.getBounds());
        }
        this.setts.setBooleanProperty(this.getKeyPrefix() + FRAME_MAXIMIZED_KEY, maximized);
    }

    public void setToolBar(JToolBar toolb) {
        this.toolBar = toolb;
        this.toolBar.setVisible(this.toolbarVisible);
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    public void setToolBarVisible(boolean visible) {
        if (this.toolbarVisible != visible) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set toolbar visible = " + visible));
            }
            if (this.toolBar != null) {
                this.toolBar.setVisible(visible);
                JPanel contentPane = (JPanel)this.getContentPane();
                contentPane.revalidate();
                contentPane.repaint();
            }
            this.toolbarVisible = visible;
            if (this.setts != null) {
                this.setts.setBooleanProperty(this.getKeyPrefix() + VIEW_TOOLBAR_KEY, this.toolbarVisible);
            }
            if (this.viewToolbarAction != null) {
                ActionRepository.setActionSelected(this.viewToolbarAction, this.toolbarVisible);
            }
        }
    }

    public void createViewToolbarAction(ActionRepository repo, String menuPath, String menuGroup, String toolBarGroup) {
        this.viewToolbarAction = new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                boolean visible = ActionRepository.isActionSelected(this);
                ApplicationFrame.this.setToolBarVisible(visible);
            }
        };
        ImageIcon ico = SharedResources.getIcon("viewToolBar.png");
        if (LanguageSupport.getOptionalLocalizedString((String)"viewToolBar_NAME", null) == null) {
            repo.addAction("viewToolBar", "Actions Toolbar", "Show/hide actions toolbar.", menuPath, menuGroup, toolBarGroup, ico, this.viewToolbarAction);
        } else {
            repo.addAction("viewToolBar", menuPath, menuGroup, toolBarGroup, ico, this.viewToolbarAction);
        }
        ActionRepository.setToggleAction(this.viewToolbarAction);
        ActionRepository.setActionSelected(this.viewToolbarAction, this.toolbarVisible);
    }

    public void languageChanged(Locale newLocale) {
        this.setTitle(LanguageSupport.getOptionalLocalizedString((String)"FRAME_TITLE", (String)this.getTitle()));
    }
}

