/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import net.sf.sfac.gui.cmp.ToolbarButton;
import net.sf.sfac.gui.cmp.ToolbarToggleButton;
import net.sf.sfac.gui.framework.BarChangeListener;
import net.sf.sfac.gui.framework.MnemonicManager;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.string.StringUtils;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRepository
implements LanguageListener {
    private static Log log = LogFactory.getLog(ActionRepository.class);
    public static final String ACTION_ID = "ActionID";
    public static final String MENU_GROUP = "MenuActionGroup";
    public static final String TOOLBAR_GROUP = "ToolbarActionGroup";
    public static final String BUTTON_MODEL = "ButtonModel";
    public static final String BUTTON_GROUP = "ButtonGroup";
    public static final String SUB_ACTIONS = "subMenuActions";
    private Map<String, Action> allActions = new HashMap<String, Action>();
    private List<Action> toolbarActions = new ArrayList<Action>();
    private List<Action> menuActions = new ArrayList<Action>();
    private JMenuBar menuBar;
    private List<BarChangeListener> listeners;
    private MnemonicManager mnemonicMgr;
    private int baseMnemonicLevel;

    public ActionRepository() {
        LanguageSupport.addLanguageListener((LanguageListener)this);
    }

    public void setMnemonicManager(MnemonicManager manager, int baseLevel) {
        this.mnemonicMgr = manager;
        this.baseMnemonicLevel = baseLevel;
    }

    public MnemonicManager getMnemonicManager() {
        if (this.mnemonicMgr == null) {
            this.mnemonicMgr = new MnemonicManager();
        }
        return this.mnemonicMgr;
    }

    public int getBaseMnemonicLevel() {
        return this.baseMnemonicLevel;
    }

    public int getActionCount() {
        return this.allActions.size();
    }

    public int getToolbarActionCount() {
        return this.toolbarActions.size();
    }

    public List<Action> getToolbarActions() {
        return this.toolbarActions;
    }

    public int getMenuActionCount() {
        return this.menuActions.size();
    }

    public List<Action> getMenuActions() {
        return this.menuActions;
    }

    public Action getAction(String actionId) {
        return this.allActions.get(actionId);
    }

    public JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.sortMenuActions(this.menuActions, new ActionComparator(MENU_GROUP));
        this.setAllMnemonics();
        this.addMenusToMenuBar();
        this.fireMenuBarCreated(this.menuBar);
        return this.menuBar;
    }

    public JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar("mainToolBar");
        Collections.sort(this.toolbarActions, new ActionComparator(TOOLBAR_GROUP));
        int len = this.toolbarActions.size();
        int currentActionGroup = -1;
        for (int i = 0; i < len; ++i) {
            Action act = this.toolbarActions.get(i);
            int actionGroup = ActionRepository.getGroup(act, TOOLBAR_GROUP);
            if (currentActionGroup != actionGroup) {
                if (i > 0) {
                    toolBar.addSeparator();
                }
                currentActionGroup = actionGroup;
            }
            AbstractButton but = ActionRepository.createToolbarButton(act);
            toolBar.add(but);
        }
        toolBar.setFloatable(false);
        this.fireToolBarCreated(toolBar);
        return toolBar;
    }

    public String toString() {
        return "ActionRepository@" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setActionSelected(Action act, boolean selected) {
        ButtonModel butModel = (ButtonModel)act.getValue(BUTTON_MODEL);
        if (butModel == null) {
            throw new IllegalArgumentException("Action '" + act.getValue("Name") + "' cannot be selected");
        }
        if (butModel.isSelected() != selected) {
            butModel.setSelected(selected);
        }
    }

    public static boolean isActionSelected(Action act) {
        ButtonModel butModel = (ButtonModel)act.getValue(BUTTON_MODEL);
        if (butModel == null) {
            throw new IllegalArgumentException("Action '" + act.getValue("Name") + "' cannot be selected");
        }
        return butModel.isSelected();
    }

    public static void setToggleAction(Action act) {
        act.putValue(BUTTON_MODEL, new JToggleButton.ToggleButtonModel());
    }

    public static void setRadioAction(Action act, ButtonGroup group) {
        act.putValue(BUTTON_MODEL, new JToggleButton.ToggleButtonModel());
        act.putValue(BUTTON_GROUP, group);
    }

    public static ImageIcon resizeIcon(ImageIcon icon, int newSize) {
        Image im = icon.getImage();
        return new ImageIcon(im.getScaledInstance(newSize, newSize, 8));
    }

    public static void registerKeyStrokes(Action act, JComponent cmp) {
        Object ks = act.getValue("AcceleratorKey");
        if (ks != null) {
            InputMap windowMap = cmp.getInputMap(2);
            ActionMap actionMap = cmp.getActionMap();
            String key = (String)act.getValue("ActionCommandKey");
            if (Comparison.isEmpty((String)key)) {
                key = (String)act.getValue("Name");
                if (Comparison.isEmpty((String)key)) {
                    throw new IllegalStateException("No command or name for action: " + act);
                }
                act.putValue("ActionCommandKey", key);
            }
            if (ks instanceof KeyStroke) {
                KeyStroke stroke = (KeyStroke)ks;
                windowMap.put(stroke, key);
            } else if (ks instanceof KeyStroke[]) {
                KeyStroke[] strokes;
                for (KeyStroke stroke : strokes = (KeyStroke[])ks) {
                    windowMap.put(stroke, key);
                }
            } else {
                throw new IllegalStateException("Bad value for attribute: AcceleratorKey in action " + key + " = " + ks);
            }
            actionMap.put(key, act);
        }
    }

    public Action addAction(String actionId, String menuPath, String menuGroup, String toolbarGroup, Icon actionIcon, Action act) {
        return this.addAction(actionId, null, null, menuPath, menuGroup, toolbarGroup, actionIcon, act);
    }

    public Action addAction(String actionId, String actionName, String actionDescr, String menuPath, String menuGroup, String toolbarGroup, Icon actionIcon, Action act) {
        act.putValue(ACTION_ID, actionId);
        this.setActionNameAndDescription(actionId, act, actionName, actionDescr);
        this.allActions.put(actionId, act);
        if (actionIcon != null) {
            act.putValue("SmallIcon", actionIcon);
        }
        if (menuPath != null) {
            String[] menuIds = this.tokenize(menuPath);
            String[] menuGroups = this.tokenize(menuGroup);
            int menuLen = menuIds.length;
            Action menuAction = this.getMenuAction(menuIds, menuGroups, menuLen - 1);
            List parentArray = (List)menuAction.getValue(SUB_ACTIONS);
            String actionGroup = menuLen < menuGroups.length ? menuGroups[menuLen] : "z8";
            act.putValue(MENU_GROUP, actionGroup);
            parentArray.add(act);
        }
        if (toolbarGroup != null) {
            act.putValue(TOOLBAR_GROUP, toolbarGroup);
            this.toolbarActions.add(act);
        }
        return act;
    }

    public Action getMenuAction(String menuPath, String menuGroup) {
        String[] menuIds = this.tokenize(menuPath);
        String[] menuGroups = this.tokenize(menuGroup);
        int menuLen = menuIds.length;
        Action menuAction = this.getMenuAction(menuIds, menuGroups, menuLen - 1);
        return menuAction;
    }

    private void addMenusToMenuBar() {
        int len = this.menuActions.size();
        for (int i = 0; i < len; ++i) {
            Action act = this.menuActions.get(i);
            JMenu menu = new JMenu(act);
            List subMenuActions = (List)act.getValue(SUB_ACTIONS);
            this.addMenuItems(menu, subMenuActions);
            this.menuBar.add(menu);
        }
    }

    private void addMenuItems(JMenu menu, List<Action> menuItemActions) {
        int currentGroup = -1;
        int len = menuItemActions.size();
        for (int i = 0; i < len; ++i) {
            List subMenuActions;
            Action act = menuItemActions.get(i);
            String actionMenuName = (String)act.getValue("Name");
            int group = ActionRepository.getGroup(act, MENU_GROUP);
            if (currentGroup != group) {
                if (i > 0) {
                    menu.addSeparator();
                }
                currentGroup = group;
            }
            if ((subMenuActions = (List)act.getValue(SUB_ACTIONS)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create menu item '" + actionMenuName + "', group='" + act.getValue(MENU_GROUP) + "'"));
                }
                JMenuItem menuItem = ActionRepository.createMenuItem(act);
                menu.add(menuItem);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create menu '" + actionMenuName + "', group='" + act.getValue(MENU_GROUP) + "'"));
            }
            JMenu subMenu = new JMenu(act);
            this.addMenuItems(subMenu, subMenuActions);
            menu.add(subMenu);
        }
    }

    private void setAllMnemonics() {
        if (this.mnemonicMgr == null) {
            this.mnemonicMgr = new MnemonicManager();
            this.baseMnemonicLevel = 0;
        } else {
            this.mnemonicMgr.clear(this.baseMnemonicLevel);
        }
        this.fireBeforeMnemonicAssignment();
        this.setMenuMnemonics(this.menuActions, this.baseMnemonicLevel);
    }

    private void setMenuMnemonics(List<Action> menuItemActions, int level) {
        Action act;
        int len = menuItemActions.size();
        for (int i = 0; i < len; ++i) {
            act = menuItemActions.get(i);
            this.mnemonicMgr.assignActionMnemonic(act, level);
        }
        int nextLevel = level + 1;
        for (int i = 0; i < len; ++i) {
            act = menuItemActions.get(i);
            List subMenuActions = (List)act.getValue(SUB_ACTIONS);
            if (subMenuActions == null) continue;
            this.mnemonicMgr.clear(nextLevel);
            this.setMenuMnemonics(subMenuActions, nextLevel);
        }
    }

    public static int getGroup(Action act, String groupKey) {
        String group = (String)act.getValue(groupKey);
        if (group == null || group.length() == 0) {
            return -1;
        }
        return group.charAt(0);
    }

    private void sortMenuActions(List<Action> list, ActionComparator comparator) {
        Collections.sort(list, comparator);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Action act = list.get(i);
            List subList = (List)act.getValue(SUB_ACTIONS);
            if (subList == null) continue;
            this.sortMenuActions(subList, comparator);
        }
    }

    private String getMenuName(String actionMenuId) {
        String menuNameKey = actionMenuId + "_MENU";
        return LanguageSupport.getOptionalLocalizedString((String)menuNameKey, (String)actionMenuId);
    }

    public static AbstractButton createButton(Action act) {
        AbstractButton but;
        ButtonModel butModel = (ButtonModel)act.getValue(BUTTON_MODEL);
        if (butModel == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create button for action '" + act.getValue("Name") + "', group='" + act.getValue(TOOLBAR_GROUP) + "'"));
            }
            but = new JButton(act);
        } else {
            ButtonGroup butGroup = (ButtonGroup)act.getValue(BUTTON_GROUP);
            if (butGroup == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create toggle button for action '" + act.getValue("Name") + "', group='" + act.getValue(TOOLBAR_GROUP) + "'"));
                }
                but = new JToggleButton(act);
                but.setModel(butModel);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create radio button for action '" + act.getValue("Name") + "', group='" + act.getValue(TOOLBAR_GROUP) + "'"));
                }
                but = new JRadioButton(act);
                but.setModel(butModel);
                butGroup.add(but);
            }
        }
        return but;
    }

    public static AbstractButton createToolbarButton(Action act) {
        AbstractButton but;
        ButtonModel butModel = (ButtonModel)act.getValue(BUTTON_MODEL);
        if (butModel == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create toolbar button for action '" + act.getValue("Name") + "', group='" + act.getValue(TOOLBAR_GROUP) + "'"));
            }
            but = new ToolbarButton(act);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create toolbar toggle button for action '" + act.getValue("Name") + "', group='" + act.getValue(TOOLBAR_GROUP) + "'"));
            }
            but = new ToolbarToggleButton(act, butModel);
            ButtonGroup butGroup = (ButtonGroup)act.getValue(BUTTON_GROUP);
            if (butGroup != null) {
                butGroup.add(but);
            }
        }
        return but;
    }

    public static JMenuItem createMenuItem(Action act) {
        JMenuItem item;
        ButtonModel butModel = (ButtonModel)act.getValue(BUTTON_MODEL);
        if (butModel == null) {
            item = new JMenuItem();
        } else {
            ButtonGroup butGroup = (ButtonGroup)act.getValue(BUTTON_GROUP);
            if (butGroup == null) {
                item = new JCheckBoxMenuItem();
                item.setModel(butModel);
            } else {
                item = new JRadioButtonMenuItem();
                item.setModel(butModel);
                butGroup.add(item);
            }
        }
        item.setAction(act);
        Icon ico = (Icon)act.getValue("SmallIcon");
        if (ico != null && (ico.getIconHeight() > 16 || ico.getIconWidth() > 16) && ico instanceof ImageIcon) {
            ImageIcon imIco = (ImageIcon)ico;
            item.setIcon(ActionRepository.resizeIcon(imIco, 16));
        }
        return item;
    }

    private String[] tokenize(String source) {
        String[] ids;
        if (source == null) {
            return new String[0];
        }
        if (source.indexOf(47) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(source, "/");
            int len = tokenizer.countTokens();
            ids = new String[len];
            for (int i = 0; i < len; ++i) {
                ids[i] = tokenizer.nextToken();
            }
        } else {
            ids = new String[]{source};
        }
        return ids;
    }

    private Action getMenuAction(String[] menuIds, String[] menuGroups, int index) {
        List parentArray;
        Action subMenuAct = null;
        String menuId = menuIds[index];
        if (index == 0) {
            parentArray = this.menuActions;
        } else {
            Action act = this.getMenuAction(menuIds, menuGroups, index - 1);
            parentArray = (List)act.getValue(SUB_ACTIONS);
        }
        int len = parentArray.size();
        for (int i = 0; i < len; ++i) {
            Action act = (Action)parentArray.get(i);
            if (!menuId.equals(act.getValue(ACTION_ID))) continue;
            subMenuAct = act;
            break;
        }
        if (subMenuAct == null) {
            subMenuAct = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                }
            };
            String menuGroup = index < menuGroups.length ? menuGroups[index] : "z9";
            String menuName = this.getMenuName(menuId);
            subMenuAct.putValue(ACTION_ID, menuId);
            subMenuAct.putValue("Name", menuName);
            subMenuAct.putValue("ShortDescription", menuName);
            subMenuAct.putValue(MENU_GROUP, menuGroup);
            subMenuAct.putValue(SUB_ACTIONS, new ArrayList());
            parentArray.add(subMenuAct);
            this.allActions.put(menuId, subMenuAct);
        }
        return subMenuAct;
    }

    public void languageChanged(Locale newLocale) {
        for (String actionId : this.allActions.keySet()) {
            Action act = this.allActions.get(actionId);
            if (act.getValue(SUB_ACTIONS) == null) {
                this.setActionNameAndDescription(actionId, act, null, null);
                continue;
            }
            String nameKey = actionId + "_MENU";
            String name = LanguageSupport.getLocalizedString((String)nameKey);
            if (name == nameKey) continue;
            act.putValue("Name", name);
            act.putValue("ShortDescription", name);
        }
        this.setAllMnemonics();
        if (this.menuBar != null) {
            this.menuBar.revalidate();
            this.menuBar.repaint();
        }
    }

    private void setActionNameAndDescription(String actionId, Action act, String directName, String directDescription) {
        String nameKey = actionId + "_NAME";
        String name = LanguageSupport.getLocalizedString((String)nameKey);
        if (name == nameKey) {
            name = Comparison.isDefined((String)directName) ? directName : StringUtils.firstToUpperCase((String)actionId);
        }
        act.putValue("Name", name);
        act.putValue("ShortDescription", name);
        String descrKey = actionId + "_DESCR";
        String descr = LanguageSupport.getLocalizedString((String)descrKey);
        if (descr == descrKey) {
            descr = Comparison.isDefined((String)directDescription) ? directDescription : name;
        }
        act.putValue("LongDescription", descr);
    }

    public void addBarChangeListener(BarChangeListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BarChangeListener>();
        }
        this.listeners.add(lis);
    }

    public void removeBarChangeListener(BarChangeListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    private void fireBeforeMnemonicAssignment() {
        int len;
        int n = len = this.listeners == null ? 0 : this.listeners.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fire menuBar created to " + len + " listeners"));
        }
        for (int i = 0; i < len; ++i) {
            BarChangeListener lis = this.listeners.get(i);
            lis.beforeMnemonicAssignment(this);
        }
    }

    private void fireMenuBarCreated(JMenuBar menubar) {
        int len;
        int n = len = this.listeners == null ? 0 : this.listeners.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fire menuBar created to " + len + " listeners"));
        }
        for (int i = 0; i < len; ++i) {
            BarChangeListener lis = this.listeners.get(i);
            lis.menubarCreated(this, menubar);
        }
    }

    private void fireToolBarCreated(JToolBar toolbar) {
        int len;
        int n = len = this.listeners == null ? 0 : this.listeners.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fire toolBar created to " + len + " listeners"));
        }
        for (int i = 0; i < len; ++i) {
            BarChangeListener lis = this.listeners.get(i);
            lis.toolbarCreated(this, toolbar);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionComparator
    implements Comparator<Action> {
        private String compareKey;

        ActionComparator(String key) {
            this.compareKey = key;
        }

        @Override
        public int compare(Action act1, Action act2) {
            String val1 = (String)act1.getValue(this.compareKey);
            String val2 = (String)act2.getValue(this.compareKey);
            return val1.compareTo(val2);
        }
    }
}

