/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import net.sf.sfac.gui.framework.ActionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionPopupMenu
implements MouseListener {
    public static final Action SEPARATOR = null;
    private List<Action> actions;
    private JPopupMenu popup;
    private JComponent parent;

    public ActionPopupMenu(JComponent parentCmp, List<Action> allActions) {
        if (allActions == null) {
            throw new IllegalArgumentException("Action array cannot be null");
        }
        if (allActions.size() == 0) {
            throw new IllegalArgumentException("Action array cannot be empty");
        }
        this.parent = parentCmp;
        this.actions = allActions;
    }

    public void addListenerOnComponents(Component cmp) {
        cmp.addMouseListener(this);
        if (cmp instanceof Container) {
            Container cnt = (Container)cmp;
            int len = cnt.getComponentCount();
            for (int i = 0; i < len; ++i) {
                this.addListenerOnComponents(cnt.getComponent(i));
            }
        }
    }

    private JPopupMenu createPopupMenu() {
        this.popup = new JPopupMenu();
        int len = this.actions.size();
        for (int i = 0; i < len; ++i) {
            Action act = this.actions.get(i);
            if (act == SEPARATOR) {
                this.popup.addSeparator();
                continue;
            }
            this.popup.add(ActionRepository.createMenuItem(act));
        }
        return this.popup;
    }

    public void showPopupMenu(Component popupParent, int x, int y) {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        this.popup.show(popupParent, x, y);
    }

    private Component getComponent(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof Component) {
            return (Component)source;
        }
        return this.parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(this.getComponent(e), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(this.getComponent(e), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(this.getComponent(e), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

