/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.framework;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.lang.LanguageSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AboutlHelper {
    private static Log log = LogFactory.getLog(AboutlHelper.class);
    private Component parentCmp;
    private String title;
    private String text;
    private String license;
    private Icon aboutImage;

    public AboutlHelper(Component parent) {
        this.parentCmp = parent;
    }

    public void setAboutIcon(Icon aboutIcon) {
        this.aboutImage = aboutIcon;
    }

    public void setDirectText(String aboutTitle, String aboutText, String aboutLicense) {
        this.title = aboutTitle;
        this.text = aboutText;
        this.license = aboutLicense;
    }

    private boolean usesLanguageSupport() {
        return this.title == null;
    }

    private String getLocalizedString(String key, String defaultText) {
        if (this.usesLanguageSupport()) {
            return LanguageSupport.getLocalizedString((String)key);
        }
        return defaultText;
    }

    public void createAction(ActionRepository repo) {
        repo.addAction("about", "Help", "z/a2", null, SharedResources.getIcon("about.gif"), new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                AboutlHelper.this.showAboutDialog();
            }
        });
    }

    public void showAboutDialog() {
        try {
            JDialog dial = new JDialog(JOptionPane.getFrameForComponent(this.parentCmp));
            dial.setTitle(this.getLocalizedString("about_title", this.title));
            if (this.aboutImage != null) {
                JLabel aboutImageLabel = new JLabel(this.aboutImage);
                aboutImageLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                dial.getContentPane().add((Component)aboutImageLabel, "West");
            }
            JLabel aboutText = new JLabel(this.getLocalizedString("about_text", this.text));
            aboutText.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            aboutText.setHorizontalAlignment(0);
            JEditorPane aboutLicense = new JEditorPane("text/html", this.getLocalizedString("about_license", this.license));
            aboutLicense.setEditable(false);
            aboutLicense.setBackground(aboutText.getBackground());
            aboutLicense.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        AboutlHelper.this.openUrl(e.getURL());
                    }
                }
            });
            aboutLicense.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JTabbedPane tabs = new JTabbedPane();
            tabs.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
            tabs.addTab(this.getLocalizedString("about_text_title", "Info"), aboutText);
            tabs.addTab(this.getLocalizedString("about_license_title", "License"), aboutLicense);
            dial.getContentPane().add((Component)tabs, "Center");
            dial.pack();
            dial.setLocationRelativeTo(this.parentCmp);
            dial.setModal(true);
            dial.setDefaultCloseOperation(2);
            dial.setVisible(true);
        }
        catch (Exception e) {
            log.error((Object)"Unable to display about dialog", (Throwable)e);
            ExceptionDialog.showExceptionDialog(this.parentCmp, "UNEXPECTED_EXCEPTION", "UNABLE_TO_SHOW_ABOUT_DIALOG", e);
        }
    }

    void openUrl(URL url) {
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(this.parentCmp, "DESKTOP_ERROR", "CANNOT_OPEN_URL", new Object[]{url.toExternalForm()}, e);
        }
    }
}

